import React, { PropsWithChildren, MouseEventHandler } from 'react';
import { IClassNameProps } from '@bem-react/core';
import './MessageBar.css';
export * from './MessageBar.classname';
export interface IMessageBarProps extends IClassNameProps {
    /**
     * Наличие иконки
     *
     * @default true
     */
    hasIcon?: boolean;
    /**
     * Обработчик клика на close элемент и индикатор того, что close надо показать
     */
    onClose?: MouseEventHandler<HTMLButtonElement>;
}
export interface IMessageBarInternalProps {
    /**
     * Тип сообщения
     * @internal
     */
    type?: 'error' | 'warning' | 'info';
}
export declare const MessageBar: React.FC<PropsWithChildren<IMessageBarProps & IMessageBarInternalProps>>;
