"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var classname_1 = require("@bem-react/classname");
var di_1 = require("@bem-react/di");
require("./SuggestOptionUser.css");
exports.cnSuggestOptionUser = classname_1.cn('SuggestOptionUser');
/**
 * Компонент для отображения пользователя в попапе саджеста
 * @param {SuggestOptionUserProps} props
 */
exports.SuggestOptionUser = function (props) {
    var className = props.className, option = props.option;
    var UserAvatar = di_1.useComponentRegistry(exports.cnSuggestOptionUser()).UserAvatar;
    return (react_1.default.createElement("div", { className: exports.cnSuggestOptionUser(null, [className]) },
        react_1.default.createElement(UserAvatar, { className: exports.cnSuggestOptionUser('Avatar'), value: option, size: 32, withoutLink: true }),
        react_1.default.createElement("div", { className: exports.cnSuggestOptionUser('Name') },
            react_1.default.createElement("div", { className: exports.cnSuggestOptionUser('FullName') }, option.display),
            react_1.default.createElement("div", { className: exports.cnSuggestOptionUser('Login') }, option.login)),
        option.department &&
            react_1.default.createElement("div", { className: exports.cnSuggestOptionUser('Department') }, option.department)));
};
