"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importStar(require("react"));
var classname_1 = require("@bem-react/classname");
var di_1 = require("@bem-react/di");
var react_hooks_1 = require("@yandex-int/react-hooks");
require("./SuggestValueUser.css");
exports.cnSuggestValueUser = classname_1.cn('SuggestValueUser');
/**
 * Компонент для отображения пользователя в инпуте саджеста
 * @param {SuggestValueUserProps} props
 */
exports.SuggestValueUser = function (props) {
    var className = props.className, value = props.value, _a = props.preferUserIcon, preferUserIcon = _a === void 0 ? false : _a, _b = props.staffCard, staffCard = _b === void 0 ? true : _b;
    var _c = di_1.useComponentRegistry(exports.cnSuggestValueUser()), UserAvatar = _c.UserAvatar, UserName = _c.UserName;
    var anchorRef = react_1.useRef(null);
    react_hooks_1.useStaffCard({
        anchorRef: anchorRef,
        login: value.login,
    }, staffCard);
    return (react_1.default.createElement("div", { className: exports.cnSuggestValueUser(null, [className]), ref: anchorRef },
        react_1.default.createElement(UserAvatar, { className: exports.cnSuggestValueUser('Avatar'), value: value, size: 20, withoutGap: true }),
        !preferUserIcon && (react_1.default.createElement(UserName, { className: exports.cnSuggestValueUser('Name'), value: value, withoutLink: true }))));
};
