"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var i18n_1 = tslib_1.__importDefault(require("@yandex-int/i18n"));
var classname_1 = require("@bem-react/classname");
var keyset = tslib_1.__importStar(require("./Table.i18n"));
require("./Table.css");
var DASH = '\u2014';
var i18n = i18n_1.default(keyset);
exports.cnTable = classname_1.cn('YcTable');
var Table = /** @class */ (function (_super) {
    tslib_1.__extends(Table, _super);
    function Table() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.renderRow = function (item, rowIndex) {
            var _a = _this.props, columns = _a.columns, isRowDisabled = _a.isRowDisabled, onRowClick = _a.onRowClick, getRowClassNames = _a.getRowClassNames;
            var disabled = isRowDisabled ? isRowDisabled(item, rowIndex) : false;
            var interactive = Boolean(!disabled && onRowClick);
            var additionalClassNames = getRowClassNames ? getRowClassNames(item, rowIndex) : [];
            return (react_1.default.createElement("tr", { key: Table.getRowId(_this.props, item), onClick: !disabled && onRowClick ? onRowClick.bind(null, item) : undefined, className: exports.cnTable('Row', { disabled: disabled, interactive: interactive }, [additionalClassNames.join(' ')]) }, columns.map(function (column, colIndex) {
                var id = column.id, align = column.align, primary = column.primary, sticky = column.sticky, withSpacer = column.withSpacer;
                var content = Table.getBodyCellContent(column, item, rowIndex);
                var styles = _this.getColumnStyles(colIndex);
                return (react_1.default.createElement("td", { key: id, style: styles, className: exports.cnTable('Cell', {
                        align: align,
                        primary: primary,
                        sticky: sticky,
                    }) }, withSpacer ?
                    react_1.default.createElement("div", { className: exports.cnTable('CellSpacer') }, content) :
                    content));
            })));
        };
        return _this;
    }
    // Static methods may be used by HOCs
    Table.getRowId = function (props, item) {
        var data = props.data, getRowId = props.getRowId;
        var index = data.indexOf(item);
        if (typeof getRowId === 'function') {
            return getRowId(item, index);
        }
        if (getRowId && getRowId in item) {
            return String(item[getRowId]);
        }
        return String(index);
    };
    Table.getHeadCellContent = function (column) {
        var id = column.id, name = column.name;
        var content;
        if (typeof name === 'function') {
            content = name();
        }
        else if (typeof name === 'string') {
            content = name;
        }
        else {
            content = id;
        }
        return (react_1.default.createElement("span", { className: exports.cnTable('ThContent') }, content));
    };
    Table.getBodyCellContent = function (column, item, rowIndex) {
        var id = column.id, template = column.template, placeholder = column.placeholder;
        var placeholderValue = placeholder || DASH;
        var value;
        if (typeof template === 'function') {
            value = template(item, rowIndex);
        }
        else if (typeof template === 'string') {
            value = item[template];
        }
        else if (item[id]) {
            value = item[id];
        }
        if ((value == null || value === '') && placeholderValue) {
            return placeholderValue;
        }
        return value;
    };
    Table.prototype.render = function () {
        var _a = this.props, columns = _a.columns, className = _a.className;
        var withPrimary = columns.some(function (_a) {
            var primary = _a.primary;
            return primary;
        });
        return (react_1.default.createElement("div", { className: exports.cnTable({ withPrimary: withPrimary }, [className]) },
            react_1.default.createElement("table", { className: exports.cnTable('Table') },
                this.renderHead(),
                this.renderBody())));
    };
    Table.prototype.renderHead = function () {
        var _this = this;
        var columns = this.props.columns;
        return (react_1.default.createElement("thead", { className: exports.cnTable('Head') },
            react_1.default.createElement("tr", { className: exports.cnTable('Row') }, columns.map(function (column, index) {
                var id = column.id, align = column.align, sticky = column.sticky, className = column.className;
                var content = Table.getHeadCellContent(column);
                return (react_1.default.createElement("th", { key: id, style: _this.getColumnStyles(index), className: exports.cnTable('Cell', {
                        align: align,
                        sticky: sticky,
                    }, [className]) }, content));
            }))));
    };
    Table.prototype.renderBody = function () {
        var data = this.props.data;
        return (react_1.default.createElement("tbody", { className: exports.cnTable('Body') }, data.length > 0 ? data.map(this.renderRow) : this.renderEmptyRow()));
    };
    Table.prototype.renderEmptyRow = function () {
        var _a = this.props, columns = _a.columns, emptyTextProp = _a.emptyText;
        var emptyText = emptyTextProp ? emptyTextProp : i18n('empty');
        return (react_1.default.createElement("tr", { className: exports.cnTable('Row', { empty: true }) },
            react_1.default.createElement("td", { className: exports.cnTable('Cell'), colSpan: columns.length },
                " ",
                emptyText,
                " ")));
    };
    Table.prototype.getColumnStyles = function (index) {
        var _a = this.props, columns = _a.columns, _b = _a.touch, touch = _b === void 0 ? false : _b;
        if (touch) {
            return {};
        }
        var column = columns[index];
        var style = {};
        if (typeof column.width !== 'undefined') {
            style.width = column.width;
            style.minWidth = column.width;
        }
        if (!column.sticky) {
            return style;
        }
        var filteredColumns = column.sticky === 'left' ? columns.slice(0, index) : columns.slice(index + 1);
        style[column.sticky] = filteredColumns.reduce(function (left, column) { return (column.width !== undefined && column.width >= 0) ?
            left + column.width :
            left; }, 0);
        return style;
    };
    return Table;
}(react_1.default.Component));
exports.Table = Table;
