"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var di_1 = require("@bem-react/di");
var ToolsSuggest_1 = require("../ToolsSuggest");
require("./ToolsSuggest-Arrow.css");
/**
 * Отключает всплытие события нажатия.
 *
 * @param event Событие.
 */
function preventArrowMouseDown(event) {
    // Не допускаем всплытия,
    // потому что на корневом компоненте есть не нужная нам обработка события
    event.stopPropagation();
    // Но отменить все равно нужно
    event.preventDefault();
}
/** Стрелка переключения видимости саджеста */
exports.ToolsSuggestArrow = function (_a) {
    var onClick = _a.onClick, className = _a.className;
    var Icon = di_1.useComponentRegistry(ToolsSuggest_1.cnToolsSuggest()).Icon;
    return (react_1.default.createElement(Icon, { glyph: "type-arrow", className: ToolsSuggest_1.cnToolsSuggest('Arrow', undefined, [className]), onClick: onClick, onMouseDown: preventArrowMouseDown }));
};
