"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importStar(require("react"));
var ToolsSuggest_1 = require("../ToolsSuggest");
require("./ToolsSuggest-Choice.css");
/**
 * Стандартная функция отрисовки значения.
 */
function defaultChildren(choice) {
    return choice.id;
}
/**
 * Компонент отображения выбранного значения.
 */
exports.ToolsSuggestChoice = react_1.memo(function (props) {
    var choice = props.choice, className = props.className, onMouseDown = props.onMouseDown, _a = props.children, children = _a === void 0 ? defaultChildren : _a, checked = props.checked, picked = props.picked;
    var handleMouseDown = react_1.useCallback(function (event) {
        if (onMouseDown) {
            onMouseDown(event, choice);
        }
    }, [onMouseDown, choice]);
    return (react_1.default.createElement("div", { key: choice.id, "data-id": choice.id, className: ToolsSuggest_1.cnToolsSuggest('Choice', {
            type: choice.type,
            picked: picked,
        }, [className]), onMouseDown: handleMouseDown },
        react_1.default.createElement("div", { className: ToolsSuggest_1.cnToolsSuggest('ChoiceBox') }, children(choice)),
        checked && (react_1.default.createElement("span", { className: ToolsSuggest_1.cnToolsSuggest('ChosenIcon') },
            react_1.default.createElement("svg", { viewBox: "0 0 14 10" },
                react_1.default.createElement("path", { d: "M5.383 7L2.155 3.498l-1.16 1.07 4.367 4.738 7.633-7.983-1.14-1.09L5.383 7z", fill: "currentColor" }))))));
});
