"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importStar(require("react"));
var ToolsSuggest_1 = require("../ToolsSuggest");
require("./ToolsSuggest-Chosen.css");
/**
 * Стандартная функция отрисовки значения.
 */
function defaultChildren(choice) {
    return choice.id;
}
/**
 * Отключает всплытие события нажатия на удаление значения.
 */
function preventChosenMouseDown(event) {
    // Не допускаем всплытия,
    // потому что на корневом компоненте есть не нужная нам обработка события
    event.stopPropagation();
    // Но отменить все равно нужно
    event.preventDefault();
}
/**
 * Компонент отображения выбранного значения.
 */
exports.ToolsSuggestChosen = react_1.memo(function (_a) {
    var _b = _a.as, AsElement = _b === void 0 ? 'span' : _b, disabled = _a.disabled, removed = _a.removed, restoreDisabled = _a.restoreDisabled, index = _a.index, choice = _a.choice, className = _a.className, onRemove = _a.onRemove, onRestore = _a.onRestore, _c = _a.children, children = _c === void 0 ? defaultChildren : _c;
    var handleRemove = react_1.useCallback(function () {
        onRemove(choice, index);
    }, [onRemove, choice, index]);
    var handleRestore = react_1.useCallback(function () {
        onRestore(choice, index);
    }, [onRestore, choice, index]);
    return (react_1.default.createElement(AsElement, { className: ToolsSuggest_1.cnToolsSuggest('Chosen', {
            disabled: disabled,
            type: choice.type,
            removed: removed,
        }, [className]) },
        react_1.default.createElement("div", { className: ToolsSuggest_1.cnToolsSuggest('ChosenBox') },
            react_1.default.createElement("div", { className: ToolsSuggest_1.cnToolsSuggest('ChosenContent') }, children(choice))),
        !disabled && !removed && (react_1.default.createElement("span", { className: ToolsSuggest_1.cnToolsSuggest('ChosenRemove'), onMouseDown: preventChosenMouseDown, onClick: handleRemove },
            react_1.default.createElement("svg", { viewBox: "0 0 9 9" },
                react_1.default.createElement("path", { d: "M9 1L8 0l-3.5 3.5L1 0 0 1.001 3.5 4.5 0 8l1 1 3.5-3.5L8 9l1-1-3.5-3.5L9 1z", fill: "currentColor" })))),
        !disabled && !restoreDisabled && removed && (react_1.default.createElement("span", { className: ToolsSuggest_1.cnToolsSuggest('ChosenRestore'), onMouseDown: preventChosenMouseDown, onClick: handleRestore },
            react_1.default.createElement("svg", { viewBox: "0 0 12 12" },
                react_1.default.createElement("path", { d: "M3.9 2.4C5.7 1.4 8 2 9.3 4c1.1 2 .4 4.3-1.6 5.5A4 4 0 013 8.9s-.5-.3-.8 0c-.4.4 0 1 0 1a5.3 5.3 0 101-8.4c-.4.1-.7.4-1 .6v-.6c0-.3-.2-.7-.6-.7-.3 0-.6.4-.5.7a39.8 39.8 0 010 2l.1.5c.2.2.4.2.7.2h1.9c.3 0 .5-.3.5-.6s-.2-.5-.6-.5A229.9 229.9 0 013 3c.2-.3.5-.5.9-.7z", fill: "currentColor" }))))));
});
