import { RefObject } from 'react';
declare type Item = import('../ToolsSuggest').Item;
export declare type UseToolsSuggestProps = {
    /** Список значений в попапе */
    choices?: Item[];
    /** Список выбранных значений */
    chosen?: Item[];
    /** Признак процесса загрузки */
    loading?: boolean;
    /** Максимальное кол-во выбранных элементов */
    maxChosen?: number;
    /** Признак фокуса в поле */
    focused?: boolean;
    /** Признак открытого попапа */
    opened?: boolean;
    /** Выделенные поля в попапе */
    picked?: Item[];
    /** Содержимое в текстовом поле */
    value?: string;
    /** Включить быстрое восстановление удалённых пунктов? */
    restorableChosen?: boolean;
    /** Пункты размещаются в строке ввода? */
    placeInline?: boolean;
    /** Показывать попап саджеста при удалении всех выбранных пунктов */
    showPopupOnEmptyChosen?: boolean;
    /** Показывать попап саджеста при фокусе в поле ввода */
    showPopupOnInputFocus?: boolean;
    /** Ставить фокус на инпут при клике на элемент */
    focusInputOnWrapperClick?: boolean;
    /** Добавляет кнопку, которая будет выставлять переданное значение */
    buttonValue?: Item;
    /** Обработчик выставления фокуса в поле */
    onInputFocus?: (focused: boolean) => void;
    /** Обработчик прокрутки в попапе */
    onChoicesScroll?: (progress: number) => void;
    /** Обработчик изменения списка выбранных значений */
    onChosenChange?: (choices: Item[]) => void;
    /** Обработчик открытия попапа */
    onOpenedChange?: (opened: boolean) => void;
    /** Обработчик изменения списка выбранных значений в попапе */
    onPickedChange?: (choices: Item[]) => void;
    /** Обработчик изменения текста */
    onValueChange?: (value: string) => void;
    /** Создаёт идентификатор исключающей группы (только один элемент с одинаковым идентификатором допускается) */
    createExcludingGroup?: (choice: Item) => unknown;
    /** Ref текстового поля */
    controlRef: RefObject<HTMLInputElement>;
    /** Ref всплывающего окна, для синхронизации ширины */
    popupRef: RefObject<HTMLDivElement>;
    /** Ref списка для выбора пунктов */
    listRef: RefObject<HTMLDivElement>;
    onBlur?: ((event: React.FocusEvent<HTMLInputElement>) => void);
    onChange?: ((event: React.ChangeEvent<HTMLInputElement>) => void);
    onKeyDown?: ((event: React.KeyboardEvent<HTMLInputElement>) => void);
    onFocus?: ((event: React.FocusEvent<HTMLInputElement>) => void);
};
/**
 * Хук для работы ToolsSuggest.
 * Вынесено для чистоты кода компонента.
 */
export declare function useToolsSuggest({ choices, chosen, maxChosen, focused, opened, picked, value, restorableChosen, placeInline, showPopupOnEmptyChosen, showPopupOnInputFocus, focusInputOnWrapperClick, buttonValue, onInputFocus, onChoicesScroll, onChosenChange, onOpenedChange, onPickedChange, onValueChange, createExcludingGroup, controlRef, listRef, onBlur, onKeyDown, onFocus, onChange, }: UseToolsSuggestProps): {
    handleInputFocus: (event: import("react").FocusEvent<HTMLInputElement>) => void;
    handleInputBlur: (event: import("react").FocusEvent<HTMLInputElement>) => void;
    handleInputChange: (event: import("react").ChangeEvent<HTMLInputElement>) => void;
    handleInputMouseDown: (event: import("react").MouseEvent<HTMLInputElement, MouseEvent>) => void;
    handleInputWrapperMouseDown: (event: import("react").MouseEvent<HTMLElement, MouseEvent>) => void;
    handleInputKeyDown: (event: import("react").KeyboardEvent<HTMLInputElement>) => void;
    handleArrowClick: (event: import("react").MouseEvent<HTMLElement, MouseEvent>) => void;
    handleChosenRemove: (choice: import("../ToolsSuggest").Item, index: number) => void;
    handleChosenRestore: (choice: import("../ToolsSuggest").Item, index: number) => void;
    handleChoicesScroll: (event: import("react").UIEvent<HTMLElement>) => void;
    handleChoiceMouseDown: (event: import("react").MouseEvent<Element, MouseEvent>, choice: import("../ToolsSuggest").Item) => void;
    handleSetValueClick: (event: import("react").MouseEvent<HTMLElement, MouseEvent>) => void;
    handlePopupClose: () => void;
    getChosenWithRemoved: () => import("../ToolsSuggest").Item[];
    isIndexInRemovedChosenItems: (index: number) => boolean;
};
export {};
