"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var react_1 = require("react");
var ToolsSuggest_utils_1 = require("../ToolsSuggest.utils");
var emptyArray = [];
var emptyHandler = function () { };
/**
 * Хук для работы ToolsSuggest.
 * Вынесено для чистоты кода компонента.
 */
function useToolsSuggest(_a) {
    /**
     * Хранение данных
     */
    var _b = _a.choices, choices = _b === void 0 ? emptyArray : _b, _c = _a.chosen, chosen = _c === void 0 ? emptyArray : _c, _d = _a.maxChosen, maxChosen = _d === void 0 ? Infinity : _d, _e = _a.focused, focused = _e === void 0 ? false : _e, _f = _a.opened, opened = _f === void 0 ? false : _f, _g = _a.picked, picked = _g === void 0 ? emptyArray : _g, _h = _a.value, value = _h === void 0 ? '' : _h, _j = _a.restorableChosen, restorableChosen = _j === void 0 ? false : _j, _k = _a.placeInline, placeInline = _k === void 0 ? true : _k, _l = _a.showPopupOnEmptyChosen, showPopupOnEmptyChosen = _l === void 0 ? true : _l, _m = _a.showPopupOnInputFocus, showPopupOnInputFocus = _m === void 0 ? true : _m, _o = _a.focusInputOnWrapperClick, focusInputOnWrapperClick = _o === void 0 ? true : _o, buttonValue = _a.buttonValue, _p = _a.onInputFocus, onInputFocus = _p === void 0 ? emptyHandler : _p, _q = _a.onChoicesScroll, onChoicesScroll = _q === void 0 ? emptyHandler : _q, _r = _a.onChosenChange, onChosenChange = _r === void 0 ? emptyHandler : _r, _s = _a.onOpenedChange, onOpenedChange = _s === void 0 ? emptyHandler : _s, _t = _a.onPickedChange, onPickedChange = _t === void 0 ? emptyHandler : _t, _u = _a.onValueChange, onValueChange = _u === void 0 ? emptyHandler : _u, createExcludingGroup = _a.createExcludingGroup, controlRef = _a.controlRef, listRef = _a.listRef, onBlur = _a.onBlur, onKeyDown = _a.onKeyDown, onFocus = _a.onFocus, onChange = _a.onChange;
    var _v = tslib_1.__read(react_1.useState(new Map()), 2), removedChosenItems = _v[0], setRemovedChosenItems = _v[1];
    /**
     * Общие команды
     */
    /** Найти пункт в списке в попапе */
    var findChoice = react_1.useCallback(function (_a) {
        var id = _a.id;
        var current = listRef.current;
        if (!current) {
            return null;
        }
        return current.querySelector("[data-id=\"" + 
        // Экранирую значение атрибута, чтобы не сломать селектор
        String(id).replace(/["\[\]]/, '\\&') + "\"]");
    }, [listRef]);
    /**
     * Команды для управления прокуткой
     */
    /** Прокрутка к текстовому полю */
    var scrollToSuggest = react_1.useCallback(function () {
        ToolsSuggest_utils_1.scrollToElem(controlRef.current);
    }, [controlRef]);
    /** Прокрутка к последнему выделенному элементу */
    var scrollToLastPicked = react_1.useCallback(function () {
        if (!picked || picked.length === 0) {
            return;
        }
        ToolsSuggest_utils_1.scrollToElem(findChoice(picked[picked.length - 1]));
    }, [picked, findChoice]);
    /**
     * Управлению фокусом в текстовом поле
     */
    /** Выставить фокус на текстовое поле */
    var focusInput = react_1.useCallback(function () {
        var controlElem = controlRef.current;
        if (controlElem) {
            controlElem.focus();
        }
    }, [controlRef]);
    /** Убрать фокус из текстового поля */
    var blurInput = react_1.useCallback(function () {
        var controlElem = controlRef.current;
        if (controlElem) {
            controlElem.blur();
        }
    }, [controlRef]);
    /**
     * Изменение текста в поле
     */
    /** Обработчик изменения текта в поле */
    var changeValue = react_1.useCallback(function (newValue) {
        if (newValue === value) {
            return false;
        }
        onValueChange(newValue);
        return true;
    }, [value, onValueChange]);
    /**
     * Изменение выделенных значений в списке
     */
    /** Обработчик изменения выделенных значения */
    var changePicked = react_1.useCallback(function (subset) {
        if (picked === subset) {
            return;
        }
        onPickedChange(subset);
    }, [picked, onPickedChange]);
    /** Установить список выделенных значений целиком */
    var setPicked = react_1.useCallback(function (subset) {
        changePicked(ToolsSuggest_utils_1.setChoicesSubset(picked, subset, maxChosen));
    }, [changePicked, picked, maxChosen]);
    /** Добавить значения к списку выделенных значений */
    var addPicked = react_1.useCallback(function (subset) {
        changePicked(ToolsSuggest_utils_1.addChoicesSubset(picked, subset, maxChosen));
    }, [changePicked, picked, maxChosen]);
    /** Удалить из списка выделенных значений */
    var removePicked = react_1.useCallback(function (subset) {
        changePicked(ToolsSuggest_utils_1.delChoicesSubset(picked, subset, maxChosen));
    }, [changePicked, picked, maxChosen]);
    /**
     * Управление видимостью всплывающего окна
     */
    /** Обработчик переключение видимости всплывающего окна */
    var changeOpened = react_1.useCallback(function (value) {
        if (value === opened) {
            return false;
        }
        onOpenedChange(value);
        return true;
    }, [opened, onOpenedChange]);
    /** Открыть всплывающее окно */
    var openPopup = react_1.useCallback(function () {
        changeOpened(true);
        focusInput();
    }, [changeOpened, focusInput]);
    /** Скрыть всплывающее окно */
    var closePopup = react_1.useCallback(function () {
        if (changeOpened(false)) {
            setPicked([]);
        }
    }, [changeOpened, setPicked]);
    /**
     * Управление значением поля
     */
    /** Обработчик изменения выбранных значений */
    var changeChosen = react_1.useCallback(function (subset) {
        if (chosen === subset) {
            return;
        }
        changeValue('');
        onChosenChange(subset);
        if (subset.length === maxChosen) {
            blurInput();
        }
        else if (showPopupOnEmptyChosen && subset.length === 0) {
            openPopup();
        }
    }, [
        chosen, changeValue, onChosenChange, maxChosen,
        showPopupOnEmptyChosen, blurInput, openPopup,
    ]);
    /** Удаляет пункты из списка удалённых */
    var removeSubsetFromRestorableItems = react_1.useCallback(function (subset) {
        var e_1, _a;
        var subsetIds = new Set(subset.map(function (_a) {
            var id = _a.id;
            return id;
        }));
        var newRemovedChosenItems = new Map(removedChosenItems);
        try {
            for (var newRemovedChosenItems_1 = tslib_1.__values(newRemovedChosenItems), newRemovedChosenItems_1_1 = newRemovedChosenItems_1.next(); !newRemovedChosenItems_1_1.done; newRemovedChosenItems_1_1 = newRemovedChosenItems_1.next()) {
                var _b = tslib_1.__read(newRemovedChosenItems_1_1.value, 2), key = _b[0], item = _b[1];
                if (subsetIds.has(item.id)) {
                    newRemovedChosenItems.delete(key);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (newRemovedChosenItems_1_1 && !newRemovedChosenItems_1_1.done && (_a = newRemovedChosenItems_1.return)) _a.call(newRemovedChosenItems_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        setRemovedChosenItems(newRemovedChosenItems);
    }, [removedChosenItems]);
    /** Изменить список выбранных значений */
    var setChosen = react_1.useCallback(function (subset) {
        removeSubsetFromRestorableItems(subset);
        changeChosen(ToolsSuggest_utils_1.setChoicesSubset(chosen, subset, maxChosen));
    }, [removeSubsetFromRestorableItems, changeChosen, chosen, maxChosen]);
    /** Добавить к списку выбранных значений */
    var addChosen = react_1.useCallback(function (subset) {
        removeSubsetFromRestorableItems(subset);
        changeChosen(ToolsSuggest_utils_1.addChoicesSubset(chosen, subset, maxChosen));
    }, [removeSubsetFromRestorableItems, changeChosen, chosen, maxChosen]);
    /** Удалить из списка выбранных значений */
    var removeChosen = react_1.useCallback(function (subset) {
        changeChosen(ToolsSuggest_utils_1.delChoicesSubset(chosen, subset, maxChosen));
    }, [chosen, maxChosen, changeChosen]);
    /** Возвращает список выбранных значений с удалёнными пунктами */
    var getChosenWithRemoved = react_1.useCallback(function () {
        var realChosenItems = ToolsSuggest_utils_1.setChoicesSubset(chosen, chosen, maxChosen);
        var chosenWithRemovedLength = realChosenItems.length + removedChosenItems.size;
        var chosenWithRemoved = new Array(chosenWithRemovedLength);
        var chosenIndex = 0;
        for (var i = 0; i < chosenWithRemovedLength; i++) {
            if (removedChosenItems.has(i)) {
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                chosenWithRemoved[i] = removedChosenItems.get(i);
            }
            else {
                chosenWithRemoved[i] = realChosenItems[chosenIndex];
                chosenIndex++;
            }
        }
        return chosenWithRemoved.filter(Boolean);
    }, [chosen, maxChosen, removedChosenItems]);
    /** Помечает как удалённый пункт в списке выбранных значений */
    var markToRemoveChosen = react_1.useCallback(function (subset, indexes) {
        var newRemovedChosenItems = new Map(removedChosenItems);
        for (var i = 0; i < subset.length; i++) {
            var item = subset[i];
            var index = indexes[i];
            newRemovedChosenItems.set(index, item);
        }
        if (ToolsSuggest_utils_1.isChoicesMapsEqual(removedChosenItems, newRemovedChosenItems)) {
            return;
        }
        setRemovedChosenItems(newRemovedChosenItems);
    }, [removedChosenItems]);
    /** Снимает с пункта в списке выбранных значений пометку об удалении */
    var restoreChosen = react_1.useCallback(function (subset, indexes) {
        var e_2, _a;
        var removedIds = new Set(tslib_1.__spread(removedChosenItems.values()).map(function (_a) {
            var id = _a.id;
            return id;
        }));
        var restoredIndexes = new Set(indexes);
        var chosenWithRemoved = getChosenWithRemoved();
        for (var i = 0; i < chosenWithRemoved.length; i++) {
            var item = chosenWithRemoved[i];
            if (item && removedIds.has(item.id) && !restoredIndexes.has(i)) {
                chosenWithRemoved[i] = undefined;
            }
        }
        var newRemovedChosenItems = new Map(removedChosenItems);
        if (createExcludingGroup) {
            // Если есть исключающие группы, надо удалить основываясь не на порядке, а с приоритетом восстановленных
            var groups = new Set(subset.map(function (item) { return createExcludingGroup(item); }).filter(Boolean));
            for (var i = 0; i < chosenWithRemoved.length; i++) {
                var item = chosenWithRemoved[i];
                if (!item) {
                    continue;
                }
                var key = createExcludingGroup(item);
                if (groups.has(key) && !restoredIndexes.has(i) && !newRemovedChosenItems.has(i)) {
                    chosenWithRemoved[i] = undefined;
                    newRemovedChosenItems.set(i, item);
                }
            }
        }
        var newSubset = chosenWithRemoved.filter(function (item) { return item !== undefined; });
        changeChosen(ToolsSuggest_utils_1.setChoicesSubset(chosen, newSubset, maxChosen));
        try {
            for (var indexes_1 = tslib_1.__values(indexes), indexes_1_1 = indexes_1.next(); !indexes_1_1.done; indexes_1_1 = indexes_1.next()) {
                var index = indexes_1_1.value;
                newRemovedChosenItems.delete(index);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (indexes_1_1 && !indexes_1_1.done && (_a = indexes_1.return)) _a.call(indexes_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
        setRemovedChosenItems(newRemovedChosenItems);
    }, [removedChosenItems, getChosenWithRemoved, createExcludingGroup, changeChosen, chosen, maxChosen]);
    /** Фильтрует элементы из одинаковых групп */
    var filterExcludingGroups = react_1.useCallback(function (subset) {
        if (!createExcludingGroup) {
            return;
        }
        var groups = new Map();
        var removeItems = [];
        var removeIndexes = [];
        for (var i = 0; i < subset.length; i++) {
            var item = subset[i];
            if (!item) {
                continue;
            }
            var key = createExcludingGroup(item);
            if (key == null) {
                continue;
            }
            if (groups.has(key)) {
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                var index = groups.get(key);
                removeIndexes.push(index);
                removeItems.push(subset[index]);
            }
            groups.set(key, i);
        }
        if (removeItems.length !== 0) {
            if (restorableChosen) {
                markToRemoveChosen(removeItems, removeIndexes);
            }
            removeChosen(removeItems);
        }
    }, [createExcludingGroup, restorableChosen, markToRemoveChosen, removeChosen]);
    var isIndexInRemovedChosenItems = react_1.useCallback(function (index) { return removedChosenItems.has(index); }, [removedChosenItems]);
    react_1.useEffect(function () {
        //  Из picked нужно удалить все те элементы, которых нет в choices
        setPicked(picked.filter(function (choice) { return ToolsSuggest_utils_1.findIndexFromTail(choices, choice) > -1; }));
    }, [picked, choices, setPicked]);
    react_1.useEffect(function () {
        //  Удаляем из выбранных пунктов те, что принадлежат одной группе
        createExcludingGroup && filterExcludingGroups(chosen);
    }, [chosen, createExcludingGroup, filterExcludingGroups]);
    react_1.useLayoutEffect(function () {
        scrollToLastPicked();
    }, [picked, scrollToLastPicked]);
    react_1.useLayoutEffect(function () {
        if (focused) {
            scrollToSuggest();
        }
    }, [focused, chosen, scrollToSuggest]);
    /** Обработчик фокуса в текстовое поле */
    var handleInputFocus = react_1.useCallback(function (event) {
        onInputFocus(true);
        if (showPopupOnInputFocus) {
            openPopup();
        }
        if (typeof onFocus === 'function') {
            onFocus(event);
        }
    }, [onFocus, onInputFocus, openPopup, showPopupOnInputFocus]);
    /** Обработчик потери фокуса в текстовом поле */
    var handleInputBlur = react_1.useCallback(function (event) {
        closePopup();
        onInputFocus(false);
        if (typeof onBlur === 'function') {
            onBlur(event);
        }
    }, [onBlur, onInputFocus, closePopup]);
    /** Обработчик изменения в текстовом поле */
    var handleInputChange = react_1.useCallback(function (event) {
        changeValue(event.target.value);
        if (value !== event.target.value) {
            openPopup();
        }
        if (typeof onChange === 'function') {
            onChange(event);
        }
    }, [value, onChange, openPopup, changeValue]);
    /** Обработчик нажатия мышкой в текстовое поле */
    var handleInputMouseDown = react_1.useCallback(function () {
        openPopup();
    }, [openPopup]);
    /**
     * Обработчик нажатия в поле саджеста.
     * Используется для фокусировки на текстовом поле при нажатии в другие элементы.
     */
    var handleInputWrapperMouseDown = react_1.useCallback(function (event) {
        if (!focusInputOnWrapperClick) {
            return;
        }
        // Keep focus
        if (event.target !== controlRef.current) {
            event.preventDefault();
        }
        focusInput();
    }, [controlRef, focusInput, focusInputOnWrapperClick]);
    /** Обработчик нажатия горячих клавиш в поле */
    var handleInputKeyDown = react_1.useCallback(function (event) {
        switch (event.key) {
            case 'Enter': {
                if (opened) {
                    // Prevent submit forms
                    event.preventDefault();
                }
                closePopup();
                addChosen(picked);
                break;
            }
            case 'ArrowDown': {
                // Prevent move caret
                event.preventDefault();
                openPopup();
                setPicked(ToolsSuggest_utils_1.findNextPicked(choices, picked, event.shiftKey));
                break;
            }
            case 'ArrowUp': {
                // Prevent move caret
                event.preventDefault();
                openPopup();
                setPicked(ToolsSuggest_utils_1.findPrevPicked(choices, picked, event.shiftKey));
                break;
            }
            case 'Backspace': {
                if (!placeInline || value || chosen.length === 0) {
                    return;
                }
                setChosen(chosen.slice(0, -1));
                if (chosen.length > 1) {
                    closePopup();
                }
                break;
            }
        }
        if (typeof onKeyDown === 'function') {
            onKeyDown(event);
        }
    }, [
        addChosen, choices, chosen, closePopup, onKeyDown, openPopup,
        opened, picked, placeInline, setChosen, setPicked, value,
    ]);
    /** Обработчик нажатия на стрелку открытия попапа */
    var handleArrowClick = react_1.useCallback(function () {
        if (opened) {
            closePopup();
        }
        else {
            openPopup();
        }
    }, [opened, closePopup, openPopup]);
    /** Обработчик удаления значения саджеста */
    var handleChosenRemove = react_1.useCallback(function (choice, index) {
        if (restorableChosen) {
            markToRemoveChosen([choice], [index]);
        }
        removeChosen([choice]);
    }, [removeChosen, markToRemoveChosen, restorableChosen]);
    /** Обработчик восстановления значения саджеста */
    var handleChosenRestore = react_1.useCallback(function (choice, index) {
        restoreChosen([choice], [index]);
    }, [restoreChosen]);
    /** Обработчик прокрутки списка пунктов в попапе */
    var handleChoicesScroll = react_1.useCallback(function () {
        var choicesElem = listRef.current;
        if (!choicesElem) {
            return;
        }
        var scrollHeight = choicesElem.scrollHeight, offsetHeight = choicesElem.offsetHeight, scrollTop = choicesElem.scrollTop;
        var progress = scrollTop / (scrollHeight - offsetHeight);
        onChoicesScroll(progress);
    }, [listRef, onChoicesScroll]);
    /** Обработчик выделения пункта */
    var handleChoiceMouseDown = react_1.useCallback(function (event, choice) {
        var ctrlKey = event.ctrlKey, metaKey = event.metaKey;
        if (ctrlKey || metaKey) {
            if (ToolsSuggest_utils_1.hasChoicesSubset(picked, [choice])) {
                removePicked([choice]);
            }
            else {
                addPicked([choice]);
            }
            return;
        }
        // Do not bubble to auto focus root element logic
        event.stopPropagation();
        // Do not affect on focus/blur logic
        event.preventDefault();
        closePopup();
        addChosen([choice]);
    }, [picked, addPicked, removePicked, closePopup, addChosen]);
    var handleSetValueClick = react_1.useCallback(function () {
        if (!buttonValue) {
            return;
        }
        addChosen([buttonValue]);
    }, [buttonValue, addChosen]);
    var handlePopupClose = closePopup;
    return {
        handleInputFocus: handleInputFocus,
        handleInputBlur: handleInputBlur,
        handleInputChange: handleInputChange,
        handleInputMouseDown: handleInputMouseDown,
        handleInputWrapperMouseDown: handleInputWrapperMouseDown,
        handleInputKeyDown: handleInputKeyDown,
        handleArrowClick: handleArrowClick,
        handleChosenRemove: handleChosenRemove,
        handleChosenRestore: handleChosenRestore,
        handleChoicesScroll: handleChoicesScroll,
        handleChoiceMouseDown: handleChoiceMouseDown,
        handleSetValueClick: handleSetValueClick,
        handlePopupClose: handlePopupClose,
        getChosenWithRemoved: getChosenWithRemoved,
        isIndexInRemovedChosenItems: isIndexInRemovedChosenItems,
    };
}
exports.useToolsSuggest = useToolsSuggest;
