"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var isChoicesEqual = function (a, b) {
    return typeof a !== 'undefined' && typeof b !== 'undefined' && a.id === b.id;
};
var isChoicesListsEqual = function (aChoices, bChoices) {
    if (aChoices.length !== bChoices.length) {
        return false;
    }
    return aChoices.every(function (aChoice, i) {
        var bChoice = bChoices[i];
        return isChoicesEqual(aChoice, bChoice);
    });
};
exports.isChoicesMapsEqual = function (m1, m2) {
    var e_1, _a;
    if (m1.size !== m2.size) {
        return false;
    }
    try {
        for (var m1_1 = tslib_1.__values(m1), m1_1_1 = m1_1.next(); !m1_1_1.done; m1_1_1 = m1_1.next()) {
            var _b = tslib_1.__read(m1_1_1.value, 2), key1 = _b[0], val1 = _b[1];
            if (!isChoicesEqual(m2.get(key1), val1)) {
                return false;
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (m1_1_1 && !m1_1_1.done && (_a = m1_1.return)) _a.call(m1_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return true;
};
exports.findIndexFromTail = function (choices, choice) {
    if (choices === void 0) { choices = []; }
    var i = choices.length;
    while (i > 0) {
        i -= 1;
        if (isChoicesEqual(choices[i], choice)) {
            return i;
        }
    }
    return -1;
};
exports.findIndexFromHead = function (choices, choice) {
    if (choices === void 0) { choices = []; }
    return choices.findIndex(function (possibleTheSameChoice) { return isChoicesEqual(possibleTheSameChoice, choice); });
};
var sortByChoices = function (choices, subset) {
    return subset.slice(0).sort(function (a, b) { return exports.findIndexFromHead(choices, a) - exports.findIndexFromHead(choices, b); });
};
var isOutOfRange = function (choices, index) {
    return index < 0 || index > choices.length - 1;
};
exports.findPrevPicked = function (choices, picked, append) {
    if (choices === void 0) { choices = []; }
    var lastPicked = picked[picked.length - 1];
    var lastPickedIndex = exports.findIndexFromHead(choices, lastPicked);
    var prevPickedIndex = lastPickedIndex === -1 ? choices.length : lastPickedIndex;
    do {
        prevPickedIndex -= 1;
        if (isOutOfRange(choices, prevPickedIndex)) {
            if (append) {
                return picked;
            }
            return picked.slice(-1);
        }
        if (exports.findIndexFromHead(picked, choices[prevPickedIndex]) > -1) {
            if (!append) {
                return picked.slice(-2, -1);
            }
            var sortPicked = sortByChoices(choices, picked);
            if (lastPicked === sortPicked[sortPicked.length - 1]) {
                return picked.slice(0, -1);
            }
            continue;
        }
        if (append) {
            return tslib_1.__spread(picked, [choices[prevPickedIndex]]);
        }
        return [choices[prevPickedIndex]];
    } while (true); // eslint-disable-line no-constant-condition
};
exports.findNextPicked = function (choices, picked, append) {
    if (choices === void 0) { choices = []; }
    var lastPicked = picked[picked.length - 1];
    var lastPickedIndex = exports.findIndexFromTail(choices, lastPicked);
    var nextPickedIndex = lastPickedIndex === -1 ? -1 : lastPickedIndex;
    do {
        nextPickedIndex += 1;
        if (isOutOfRange(choices, nextPickedIndex)) {
            if (append) {
                return picked;
            }
            return picked.slice(-1);
        }
        if (exports.findIndexFromTail(picked, choices[nextPickedIndex]) > -1) {
            if (!append) {
                return picked.slice(-2, -1);
            }
            var sortPicked = sortByChoices(choices, picked);
            if (lastPicked === sortPicked[0]) {
                return picked.slice(0, -1);
            }
            continue;
        }
        if (append) {
            return tslib_1.__spread(picked, [choices[nextPickedIndex]]);
        }
        return [choices[nextPickedIndex]];
    } while (true); // eslint-disable-line no-constant-condition
};
var uniChoices = function (choices) {
    var e_2, _a;
    var result = [];
    try {
        for (var choices_1 = tslib_1.__values(choices), choices_1_1 = choices_1.next(); !choices_1_1.done; choices_1_1 = choices_1.next()) {
            var choice = choices_1_1.value;
            if (exports.findIndexFromTail(result, choice) === -1) {
                result.push(choice);
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (choices_1_1 && !choices_1_1.done && (_a = choices_1.return)) _a.call(choices_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return result;
};
exports.setChoicesSubset = function (choices, subset, maxChoices) {
    var uniques = uniChoices(subset);
    // eslint-disable-next-line no-nested-ternary
    var newChoices = isFinite(maxChoices) ?
        (maxChoices < 1 ?
            [] :
            uniques.slice(Math.min(uniques.length, maxChoices) * -1)) :
        uniques;
    if (isChoicesListsEqual(choices, newChoices)) {
        return choices;
    }
    return newChoices;
};
exports.addChoicesSubset = function (choices, subset, maxChoices) {
    var newChoices = tslib_1.__spread(choices, subset);
    return exports.setChoicesSubset(choices, newChoices, maxChoices);
};
exports.delChoicesSubset = function (choices, subset, maxChoices) {
    var newChoices = subset.reduce(function (acc, delChoice) { return acc.filter(function (c) { return !isChoicesEqual(delChoice, c); }); }, choices);
    return exports.setChoicesSubset(choices, newChoices, maxChoices);
};
exports.hasChoicesSubset = function (choices, subset) {
    return subset.every(function (hasChoice) { return exports.findIndexFromTail(choices, hasChoice) > -1; });
};
exports.eventHandler = function () {
    // Noop
};
exports.scrollToElem = function (elem) {
    if (!elem) {
        return;
    }
    elem.scrollIntoView({
        behavior: 'auto',
        block: 'nearest',
        inline: 'nearest',
    });
};
