"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importStar(require("react"));
var classname_1 = require("@bem-react/classname");
var di_1 = require("@bem-react/di");
var react_hooks_1 = require("@yandex-int/react-hooks");
require("./UserAvatar.css");
exports.cnUserAvatar = classname_1.cn('UserAvatar');
/**
 * Компонент аватарки пользователя с гэпом.
 * @param {UserAvatarProps} props
 */
exports.UserAvatar = function (props) {
    var className = props.className, value = props.value, _a = props.size, size = _a === void 0 ? 32 : _a, _b = props.withoutLink, withoutLink = _b === void 0 ? false : _b, _c = props.withoutGap, withoutGap = _c === void 0 ? false : _c, withStaffCard = props.withStaffCard, target = props.target, title = props.title;
    var Link = di_1.useComponentRegistry(exports.cnUserAvatar()).Link;
    var content = [(react_1.default.createElement("img", { key: "image", className: exports.cnUserAvatar('Image'), src: value.icon, alt: value.display, width: size, height: size, 
            // @ts-ignore
            loading: "lazy" }))];
    var mods = {
        dismissed: value.dismissed || false,
    };
    // по умолчанию поле не присылают, подразумевая значение true
    var hasLicense = 'hasLicense' in value ? value.hasLicense : true;
    var anchorRef = react_1.useRef(null);
    react_hooks_1.useStaffCard({
        anchorRef: anchorRef,
        login: value.login,
    }, withStaffCard);
    if (!withoutGap &&
        value.gap &&
        value.gap.working !== true &&
        !value.dismissed &&
        hasLicense) {
        if (size < 30) {
            mods.gap = value.gap.type.replace(/_/g, '-');
        }
        else {
            content.push(react_1.default.createElement("span", { key: "gap", className: exports.cnUserAvatar('Gap', { type: value.gap.type.replace(/_/g, '-') }), title: value.gap.message }, value.gap.message));
        }
    }
    var style = react_1.useMemo(function () { return ({
        '--user-avatar-size': size,
    }); }, [size]);
    if (withoutLink) {
        return (react_1.default.createElement("span", { className: exports.cnUserAvatar(mods, [className]), style: style, ref: withStaffCard ? anchorRef : undefined, title: title }, content));
    }
    return (react_1.default.createElement(Link, { theme: "black", className: exports.cnUserAvatar(mods, [className]), style: style, href: value.url, controlRef: withStaffCard ? anchorRef : undefined, target: value.url ? target || '_blank' : undefined, title: title }, content));
};
