"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var di_1 = require("@bem-react/di");
var UserName_classname_1 = require("./UserName.classname");
require("./UserName.css");
tslib_1.__exportStar(require("./UserName.classname"), exports);
/**
 * Выводит имя пользователя
 * @param {UserNameProps} props
 */
exports.UserName = function (_a) {
    var className = _a.className, value = _a.value, preferLogin = _a.preferLogin, withoutLink = _a.withoutLink;
    var Link = di_1.useComponentRegistry(UserName_classname_1.cnUserName()).Link;
    var content = preferLogin ? value.login : value.display;
    var mods = {
        dismissed: value.dismissed,
    };
    if (withoutLink) {
        return (react_1.default.createElement("span", { className: UserName_classname_1.cnUserName(mods, [className]) }, content));
    }
    return (react_1.default.createElement(Link, { theme: "black", className: UserName_classname_1.cnUserName(mods, [className]), href: value.url }, content));
};
