import * as React from 'react';
import { IClassNameProps } from '@bem-react/core';
interface IWikiFormatterSettings {
    /**
     * Инстанс.
     */
    instance: 'intranet' | 'business';
    /**
     * Платформа.
     */
    platform: 'desktop' | 'touch';
    /**
     * Язык интерфейса.
     */
    lang: 'ru' | 'en';
    /**
     * Тема, для подсветки блоков кода.
     */
    code_theme: 'dark' | 'solarized_dark' | 'solarized_light' | 'idea' | 'github';
    /**
     * Хост wiki-formatter-as-a-service
     * */
    wfaasUrl: string;
    /**
     * Хост магических ссылок.
     */
    magiclinks_url: string;
    /**
     * Ссылка на Трекер.
     */
    tracker_url: string;
    /**
     * Ссылка на Стафф.
     */
    staff_url: string;
    /**
     * Ссылка на бэкенд для экшенов.
     */
    schi_url: string;
    /**
     * Ссылка на Этушку
     */
    at_url: string;
    /**
     * Ссылка на Конструктор форм.
     */
    forms_url: string;
    /**
     * Ссылка на Вики.
     */
    wiki_url: string;
    /**
     * Ссылка на АПИ Вики.
     */
    wiki_api_url: string;
    /**
     * Ссылка на Docviewer.
     */
    docviewer_url: string;
    /**
     * Ссылка на Charts.
     */
    charts_url: string;
    /**
     * Ссылка на Statface.
     */
    statface_url: string;
    /**
     * Ссылка на статику.
     */
    yastatic_url: string;
    /**
     * Id организации. Имеет смысл только для b2b инсталляций.
     */
    orgId?: string;
    /**
     * Настройки для парсера `remark`
     */
    remark: {
        /**
         * Настройки для плагина `remark-woofmd`
         */
        woofmd: {
            actions: {
                name: string;
            }[];
        };
    };
}
declare type IWikiFormatterUserSettings = Partial<IWikiFormatterSettings>;
declare global {
    namespace Ya {
        interface IFormatterViewPortSettings {
            domElem: HTMLElement;
            settings: IWikiFormatterUserSettings;
        }
        class FormatterViewPort {
            constructor(options: IFormatterViewPortSettings);
            renderToString(source: string): Promise<string>;
            static init(domElem: HTMLElement): void;
        }
    }
}
interface IOnFormatterInstance {
    (formatter: Ya.FormatterViewPort): void;
}
export interface IWikiFormatterHtmlProps extends IClassNameProps {
    nonce: string;
    html: string;
    settings?: IWikiFormatterUserSettings;
    onFormatterInstance?: IOnFormatterInstance;
}
export interface IWikiFormatterProps extends IClassNameProps {
    nonce: string;
    settings?: IWikiFormatterUserSettings;
    children?: string;
    onContentUpdated?: () => void;
}
export declare const WikiFormatterHtml: React.FC<IWikiFormatterHtmlProps>;
export declare const WikiFormatter: React.FC<IWikiFormatterProps>;
export {};
