"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var Datepicker_1 = require("../components/Datepicker/Datepicker");
/**
 * Хук для парсинга дат Datepicker и перевода их в строки.
 * Также содержит в себе обработчик для onDateChange.
 */
function useDatepickerStringDates(_a) {
    var value = _a.value, min = _a.min, max = _a.max, onChange = _a.onChange;
    var handleDateChange = react_1.useCallback(function (date) {
        if (onChange) {
            onChange({ target: { value: Datepicker_1.formatDate(date) || '' } });
        }
    }, [onChange]);
    return {
        value: Datepicker_1.parseDate(value),
        min: Datepicker_1.parseDate(min),
        max: Datepicker_1.parseDate(max),
        handleDateChange: handleDateChange,
    };
}
exports.useDatepickerStringDates = useDatepickerStringDates;
