import i18nFactory, { getI18nLang } from '@yandex-int/i18n';
import dateParse from 'date-fns/parse';
import dateFormat from 'date-fns/format';
import dateIsValid from 'date-fns/isValid';
import * as locales from './DatepickerLocale.i18n';
import * as keyset from './Datepicker.i18n';
import './Datepicker.css';
export * from './Datepicker.classname';
/**
 * Генерация даты, для date-fns/parse, для задания времени 00:00:00
 *
 * Вывод: Sat Jan 01 2000 00:00:00 GMT+0300 (Moscow Standard Time)
 */
var dateFnsBackupDate = new Date(Date.UTC(1995, 4, 13, 0, 0, 0, 0));
export var i18n = i18nFactory(keyset);
/**
 * Формат парсинга даты по-умолчанию
 */
export var DEFAULT_DATE_FORMAT = 'yyyy-MM-dd';
/**
 * Формат отображения даты по-умолчанию
 */
export var DEFAULT_DISPLAY_FORMAT = 'dd.MM.yyyy';
/**
 * Получение локали в зависимости от языка заданного @yandex-int/i18n.
 *
 * @returns {Locale}
 */
export function getLocale() {
    return locales[getI18nLang()] || locales.ru;
}
/**
 * Форматирование значения value, min и max в строку.
 * Используется для перевода объекта даты в текст на уровне переопределения touch-phone.
 * Может пригодиться при реализации обертки.
 *
 * @param {Date | null | undefined} date Дата.
 * @param {String} format Формат даты. По-умолчанию yyyy-MM-dd.
 */
export function formatDate(date, format) {
    if (format === void 0) { format = DEFAULT_DATE_FORMAT; }
    if (date && dateIsValid(date)) {
        return dateFormat(date, format, { locale: getLocale() });
    }
    return undefined;
}
/**
 * Парсинг текстового значения даты в объект Date.
 * Используется для перевода текста в объекта даты на уровне переопределения touch-phone.
 * Может пригодиться при реализации обертки.
 *
 * @param {String | null | undefined} dateValue Значение даты.
 * @param {String} format Формат даты. По-умолчанию yyyy-MM-dd.
 */
export function parseDate(dateValue, format) {
    if (format === void 0) { format = DEFAULT_DATE_FORMAT; }
    var value = typeof dateValue === 'string' ? dateValue.trim() : '';
    if (!value) {
        return undefined;
    }
    var date = dateParse(value, format, dateFnsBackupDate, { locale: getLocale() });
    if (dateIsValid(date)) {
        return date;
    }
    throw new Error("\u041F\u0440\u0438 \u043F\u0430\u0440\u0441\u0438\u043D\u0433\u0435 \u0434\u0430\u0442\u044B \u043F\u0440\u043E\u0438\u0437\u043E\u0448\u043B\u0430 \u043E\u0448\u0438\u0431\u043A\u0430.\n\u0422\u0435\u043A\u0443\u0449\u0435\u0435 \u0437\u043D\u0430\u0447\u0435\u043D\u0438\u0435 \"" + dateValue + ". \u0418\u0441\u043F\u043E\u043B\u044C\u0437\u0443\u0435\u043C\u044B\u0439 \u0444\u043E\u0440\u043C\u0430\u0442 \"" + format + "\"");
}
/**
 * Временное решение пока dist-ts-generator не научится выгружать хуки
 *
 * @deprecated
 */
export * from '../../hooks/useDatepickerStringDates';
