import { __assign, __rest } from "tslib";
import React, { useCallback } from 'react';
import { withRegistry, useComponentRegistry } from '@bem-react/di';
import isAfterDate from 'date-fns/isAfter';
import isBeforeDate from 'date-fns/isBefore';
import { cnDatepicker, formatDate, parseDate } from './Datepicker';
import { datepickerRegistry } from './Datepicker.registry/touch-phone';
export * from './Datepicker';
var DatepickerPresenter = function (_a) {
    var className = _a.className, dateFormat = _a.dateFormat, max = _a.max, min = _a.min, onBlur = _a.onBlur, onChange = _a.onChange, onDateChange = _a.onDateChange, preventOpenOnFocus = _a.preventOpenOnFocus, value = _a.value, direction = _a.direction, props = __rest(_a, ["className", "dateFormat", "max", "min", "onBlur", "onChange", "onDateChange", "preventOpenOnFocus", "value", "direction"]);
    /** Защита от ввода значений вне диапазона разрешенных */
    var handleBlur = useCallback(function (event) {
        if (onDateChange && value) {
            if (min && isBeforeDate(value, min)) {
                onDateChange(min);
                return;
            }
            if (max && isAfterDate(value, max)) {
                onDateChange(max);
                return;
            }
        }
        if (onBlur) {
            onBlur(event);
        }
    }, [formatDate(value), formatDate(min), formatDate(max)]);
    /** Обработчик изменения поля с форматированием значения в дату */
    var handleChange = useCallback(function (event) {
        if (onChange) {
            onChange(event);
        }
        if (onDateChange) {
            var value_1 = event.target.value.trim();
            if (!value_1) {
                onDateChange(null);
                return;
            }
            try {
                var date = parseDate(value_1);
                onDateChange(date || null);
            }
            catch (error) {
            }
        }
    }, [onChange, onDateChange]);
    var _b = useComponentRegistry(cnDatepicker()), Textinput = _b.Textinput, CalendarIcon = _b.CalendarIcon;
    return (React.createElement(Textinput, __assign({}, props, { className: cnDatepicker({ view: props.view }, [className]), value: formatDate(value), min: formatDate(min), max: formatDate(max), onChange: handleChange, onBlur: handleBlur, type: "date", baseline: true, iconRight: React.createElement(CalendarIcon, { type: "calendar" }) })));
};
export var Datepicker = withRegistry(datepickerRegistry)(DatepickerPresenter);
