import { __assign } from "tslib";
import React, { useMemo } from 'react';
import { createPortal } from 'react-dom';
import ReactDatepickerPresenter from 'react-datepicker';
import { useComponentRegistry } from '@bem-react/di';
import isValidDate from 'date-fns/isValid';
import { canUseDOM } from '../../../lib/canUseDOM';
import { cnDatepicker, DEFAULT_DISPLAY_FORMAT, getLocale, i18n, } from '../Datepicker';
import './ReactDatepicker.raw.css';
var noop = function () { };
var PopperPortal = function (_a) {
    var children = _a.children;
    if (!canUseDOM()) {
        return null;
    }
    return createPortal(children, document.body);
};
export var ReactDatepicker = function (_a) {
    var pin = _a.pin, size = _a.size, theme = _a.theme, view = _a.view, state = _a.state, hint = _a.hint, ariaLabelledBy = _a.ariaLabelledBy, autoComplete = _a.autoComplete, autoFocus = _a.autoFocus, className = _a.className, controlRef = _a.controlRef, direction = _a.direction, preventOverflow = _a.preventOverflow, overflowPadding = _a.overflowPadding, disabled = _a.disabled, id = _a.id, min = _a.min, max = _a.max, name = _a.name, onBlur = _a.onBlur, onChange = _a.onChange, onDateChange = _a.onDateChange, onFocus = _a.onFocus, onKeyDown = _a.onKeyDown, placeholder = _a.placeholder, readOnly = _a.readOnly, required = _a.required, tabIndex = _a.tabIndex, title = _a.title, value = _a.value, _b = _a.dateFormat, dateFormat = _b === void 0 ? DEFAULT_DISPLAY_FORMAT : _b, preventOpenOnFocus = _a.preventOpenOnFocus, _c = _a.adjustDateOnChange, adjustDateOnChange = _c === void 0 ? true : _c;
    var _d = useComponentRegistry(cnDatepicker()), Textinput = _d.Textinput, CalendarIcon = _d.CalendarIcon;
    var calendarIcon = useMemo(function () {
        return (React.createElement(CalendarIcon, { size: size, type: "calendar" }));
    }, [size]);
    var popperModifiers = {};
    var padding;
    if (overflowPadding) {
        padding = { padding: overflowPadding };
    }
    if (preventOverflow === true) {
        popperModifiers.preventOverflow = __assign({ enabled: true, boundariesElement: 'viewport' }, padding);
    }
    else if (typeof preventOverflow === 'object') {
        popperModifiers.preventOverflow = preventOverflow;
    }
    return (React.createElement("div", { className: cnDatepicker({ view: view }, [className]) },
        React.createElement(ReactDatepickerPresenter, { ariaLabelledBy: ariaLabelledBy, autoComplete: autoComplete, autoFocus: autoFocus, dateFormat: dateFormat, disabled: disabled, id: id, locale: getLocale(), 
            // Если возвращать null вместо undefined для даты, перестает работать управление с клавиатуры
            maxDate: max && isValidDate(max) ? max : undefined, minDate: min && isValidDate(min) ? min : undefined, name: name, onBlur: onBlur, onChange: onDateChange || noop, onChangeRaw: onChange, onFocus: onFocus, onKeyDown: onKeyDown, placeholderText: placeholder, popperPlacement: direction, popperModifiers: preventOverflow ? popperModifiers : undefined, preventOpenOnFocus: preventOpenOnFocus, readOnly: readOnly, required: required, selected: value && isValidDate(value) ? value : null, tabIndex: tabIndex, title: title, 
            // Переводы
            previousMonthButtonLabel: i18n('previousMonthButtonLabel'), nextMonthButtonLabel: i18n('nextMonthButtonLabel'), previousYearButtonLabel: i18n('previousYearButtonLabel'), nextYearButtonLabel: i18n('nextYearButtonLabel'), 
            // Свойства отвечающие за визуальное представление
            adjustDateOnChange: adjustDateOnChange, peekNextMonth: true, popperContainer: PopperPortal, showMonthDropdown: true, showPopperArrow: false, showYearDropdown: true, strictParsing: true, customInput: React.createElement(Textinput, { pin: pin, size: size, theme: theme, view: view, state: state, hint: hint, controlRef: controlRef, baseline: true, iconRight: calendarIcon }), customInputRef: "innerRef" // Textinput
         })));
};
