import React from 'react';
import { IClassNameProps } from '@bem-react/core';
import './Informer.css';
interface IMultiLangString {
    [lang: string]: string;
}
export interface IInformer {
    id: string;
    title: IMultiLangString;
    text: IMultiLangString;
    button: {
        text: IMultiLangString;
        link?: string;
    };
    currentInformerTimeout: number;
    iconUrl: string;
}
export interface IHandleClose {
    (params: {
        withAction: boolean;
    }): void;
}
export interface IInformerProps extends IClassNameProps {
    data: IInformer;
    lang: string;
    onClose?: IHandleClose;
}
declare const Informer: React.FC<IInformerProps>;
export { Informer };
