import React from 'react';
import { useComponentRegistry } from '@bem-react/di';
import { informerRegistryId, } from './Informer.registry';
import { cnInformer } from './Informer.classname';
import './Informer.css';
var Informer = function (props) {
    var _a = useComponentRegistry(informerRegistryId), MessageBox = _a.MessageBox, Button = _a.Button, Corner = _a.Corner;
    var data = props.data, lang = props.lang, _b = props.onClose, onClose = _b === void 0 ? function () { } : _b, className = props.className;
    var handleButtonClick = React.useCallback(function () {
        onClose({ withAction: Boolean(data.button.link) });
    }, [onClose, data.button.link]);
    var handleClose = React.useCallback(function () {
        onClose({ withAction: false });
    }, [onClose]);
    return (React.createElement(MessageBox, { className: cnInformer({}, [className]), view: "promo", size: "l", layout: "functional", actions: React.createElement(React.Fragment, null,
            data.button.link && (React.createElement(Button, { size: "m", type: "link", view: "action", url: data.button.link, target: "_blank", onClick: handleButtonClick }, data.button.text[lang])),
            !data.button.link && (React.createElement(Button, { size: "m", view: "default", onClick: handleButtonClick }, data.button.text[lang]))), corner: React.createElement(Corner, { width: 55, side: "top-left" },
            React.createElement("img", { className: cnInformer('Icon'), src: data.iconUrl })), onClose: handleClose },
        React.createElement("div", { className: cnInformer('Content') },
            React.createElement("div", { className: cnInformer('Title') }, data.title[lang]),
            React.createElement("div", { className: cnInformer('Text') }, data.text[lang]))));
};
export { Informer };
