import React from 'react';
import { cn } from '@bem-react/classname';
import { useComponentRegistry } from '@bem-react/di';
import './SuggestOptionUser.css';
export var cnSuggestOptionUser = cn('SuggestOptionUser');
/**
 * Компонент для отображения пользователя в попапе саджеста
 * @param {SuggestOptionUserProps} props
 */
export var SuggestOptionUser = function (props) {
    var className = props.className, option = props.option;
    var UserAvatar = useComponentRegistry(cnSuggestOptionUser()).UserAvatar;
    return (React.createElement("div", { className: cnSuggestOptionUser(null, [className]) },
        React.createElement(UserAvatar, { className: cnSuggestOptionUser('Avatar'), value: option, size: 32, withoutLink: true }),
        React.createElement("div", { className: cnSuggestOptionUser('Name') },
            React.createElement("div", { className: cnSuggestOptionUser('FullName') }, option.display),
            React.createElement("div", { className: cnSuggestOptionUser('Login') }, option.login)),
        option.department &&
            React.createElement("div", { className: cnSuggestOptionUser('Department') }, option.department)));
};
