import React, { useRef } from 'react';
import { cn } from '@bem-react/classname';
import { useComponentRegistry } from '@bem-react/di';
import { useStaffCard } from '@yandex-int/react-hooks';
import './SuggestValueUser.css';
export var cnSuggestValueUser = cn('SuggestValueUser');
/**
 * Компонент для отображения пользователя в инпуте саджеста
 * @param {SuggestValueUserProps} props
 */
export var SuggestValueUser = function (props) {
    var className = props.className, value = props.value, _a = props.preferUserIcon, preferUserIcon = _a === void 0 ? false : _a, _b = props.staffCard, staffCard = _b === void 0 ? true : _b;
    var _c = useComponentRegistry(cnSuggestValueUser()), UserAvatar = _c.UserAvatar, UserName = _c.UserName;
    var anchorRef = useRef(null);
    useStaffCard({
        anchorRef: anchorRef,
        login: value.login,
    }, staffCard);
    return (React.createElement("div", { className: cnSuggestValueUser(null, [className]), ref: anchorRef },
        React.createElement(UserAvatar, { className: cnSuggestValueUser('Avatar'), value: value, size: 20, withoutGap: true }),
        !preferUserIcon && (React.createElement(UserName, { className: cnSuggestValueUser('Name'), value: value, withoutLink: true }))));
};
