import React, { ReactNode } from 'react';
import './Table.css';
export declare type TableDataItem = Record<string, unknown>;
export declare type TableColumnConfig<T> = {
    id: string;
    name?: string | (() => ReactNode);
    placeholder?: ReactNode;
    template?: keyof T | ((item: T, rowIndex: number) => ReactNode);
    align?: 'left' | 'center' | 'right';
    primary?: boolean;
    sticky?: 'left' | 'right';
    width?: number;
    withSpacer?: boolean;
    meta?: Record<string, unknown>;
    className?: string;
};
export declare type TableProps<T> = {
    data: T[];
    columns: TableColumnConfig<T>[];
    getRowId?: keyof T | ((item: T, index: number) => string);
    getRowClassNames?: (item: T, index: number) => string[];
    isRowDisabled?: (item: T, index: number) => boolean;
    onRowClick?: (item: T, event: React.MouseEvent<HTMLTableRowElement>) => void;
    className?: string;
    emptyText?: string;
    width?: 'max';
    touch?: boolean;
};
export declare const cnTable: import("@bem-react/classname").ClassNameFormatter;
export declare class Table<T extends TableDataItem> extends React.Component<TableProps<T>> {
    static getRowId<T extends TableDataItem>(props: TableProps<T>, item: T): string;
    static getHeadCellContent<T extends TableDataItem>(column: TableColumnConfig<T>): ReactNode;
    static getBodyCellContent<T extends TableDataItem>(column: TableColumnConfig<T>, item: T, rowIndex: number): ReactNode;
    render(): JSX.Element;
    private renderHead;
    private renderBody;
    private renderRow;
    private renderEmptyRow;
    private getColumnStyles;
}
export declare type TTable = typeof Table;
