import React from 'react';
import { useComponentRegistry } from '@bem-react/di';
import { cnToolsSuggest } from '../ToolsSuggest';
import './ToolsSuggest-Arrow.css';
/**
 * Отключает всплытие события нажатия.
 *
 * @param event Событие.
 */
function preventArrowMouseDown(event) {
    // Не допускаем всплытия,
    // потому что на корневом компоненте есть не нужная нам обработка события
    event.stopPropagation();
    // Но отменить все равно нужно
    event.preventDefault();
}
/** Стрелка переключения видимости саджеста */
export var ToolsSuggestArrow = function (_a) {
    var onClick = _a.onClick, className = _a.className;
    var Icon = useComponentRegistry(cnToolsSuggest()).Icon;
    return (React.createElement(Icon, { glyph: "type-arrow", className: cnToolsSuggest('Arrow', undefined, [className]), onClick: onClick, onMouseDown: preventArrowMouseDown }));
};
