import React, { ReactNode, MouseEvent } from 'react';
import { IClassNameProps } from '@bem-react/core';
import { Item } from '../ToolsSuggest';
import './ToolsSuggest-Choice.css';
interface IToolsSuggestChoiceProps extends IClassNameProps {
    /** Значение */
    choice: Item;
    /** Значение выделено */
    picked?: boolean;
    /** Значение выбрано */
    checked?: boolean;
    /** Отображение значения */
    children?: (choice: Item) => ReactNode;
    /** Обработчик нажатия на пункт */
    onMouseDown?: (event: MouseEvent<HTMLElement>, choice: Item) => void;
}
/**
 * Компонент отображения выбранного значения.
 */
export declare const ToolsSuggestChoice: React.MemoExoticComponent<(props: IToolsSuggestChoiceProps) => JSX.Element>;
export {};
