import React, { memo, useCallback } from 'react';
import { cnToolsSuggest } from '../ToolsSuggest';
import './ToolsSuggest-Choice.css';
/**
 * Стандартная функция отрисовки значения.
 */
function defaultChildren(choice) {
    return choice.id;
}
/**
 * Компонент отображения выбранного значения.
 */
export var ToolsSuggestChoice = memo(function (props) {
    var choice = props.choice, className = props.className, onMouseDown = props.onMouseDown, _a = props.children, children = _a === void 0 ? defaultChildren : _a, checked = props.checked, picked = props.picked;
    var handleMouseDown = useCallback(function (event) {
        if (onMouseDown) {
            onMouseDown(event, choice);
        }
    }, [onMouseDown, choice]);
    return (React.createElement("div", { key: choice.id, "data-id": choice.id, className: cnToolsSuggest('Choice', {
            type: choice.type,
            picked: picked,
        }, [className]), onMouseDown: handleMouseDown },
        React.createElement("div", { className: cnToolsSuggest('ChoiceBox') }, children(choice)),
        checked && (React.createElement("span", { className: cnToolsSuggest('ChosenIcon') },
            React.createElement("svg", { viewBox: "0 0 14 10" },
                React.createElement("path", { d: "M5.383 7L2.155 3.498l-1.16 1.07 4.367 4.738 7.633-7.983-1.14-1.09L5.383 7z", fill: "currentColor" }))))));
});
