import React, { ReactNode, ElementType } from 'react';
import { IClassNameProps } from '@bem-react/core';
import { Item } from '../ToolsSuggest';
import './ToolsSuggest-Chosen.css';
interface IToolsSuggestChosenProps extends IClassNameProps {
    /** Тип элемента (тег) для отображения компонента */
    as?: ElementType;
    /** Индекс элемента в массиве */
    index: number;
    /** Значение */
    choice: Item;
    /** Обработчик нажатия на крестик */
    onRemove: (choice: Item, itemIndex: number) => void;
    /** Обработчик нажатия на кнопку восстановления пункта */
    onRestore: (choice: Item, itemIndex: number) => void;
    /** Отключение */
    disabled?: boolean;
    /** Отключение восстановления */
    restoreDisabled?: boolean;
    /** Помечен удалённым */
    removed?: boolean;
    /** Отображение значения */
    children?: (choice: Item) => ReactNode;
}
/**
 * Компонент отображения выбранного значения.
 */
export declare const ToolsSuggestChosen: React.MemoExoticComponent<({ as: AsElement, disabled, removed, restoreDisabled, index, choice, className, onRemove, onRestore, children, }: IToolsSuggestChosenProps) => JSX.Element>;
export {};
