import { withRegistry, Registry } from '@bem-react/di';
import { compose, composeU } from '@bem-react/core';
// Registry dependencies
import { Textinput } from '@yandex-lego/components/Textinput/desktop/bundle';
import { Popup } from '@yandex-lego/components/Popup/desktop/bundle';
import { Icon } from '@yandex-lego/components/Icon/desktop/bundle';
import { Button } from '@yandex-lego/components/Button/desktop/bundle';
// base
import { ToolsSuggest as ToolsSuggestDesktop, cnToolsSuggest } from '../ToolsSuggest@desktop';
// _size
import { withSizeM } from '../_size/ToolsSuggest_size_m';
import { withSizeS } from '../_size/ToolsSuggest_size_s';
// _theme
import { withThemeNormal } from '../_theme/ToolsSuggest_theme_normal';
// _view
import { withViewDefault } from '../_view/ToolsSuggest_view_default';
var registry = new Registry({ id: cnToolsSuggest() })
    .set('Textinput', Textinput)
    .set('Popup', Popup)
    .set('Icon', Icon)
    .set('Button', Button);
export * from '../ToolsSuggest@desktop';
export var ToolsSuggest = compose(composeU(withSizeM, withSizeS), withThemeNormal, withViewDefault, withRegistry(registry))(ToolsSuggestDesktop);
