import { withRegistry, Registry } from '@bem-react/di';
import { compose, composeU } from '@bem-react/core';
// Registry dependencies
import { Textinput } from '@yandex-lego/components/Textinput/touch-phone/bundle';
import { Popup } from '@yandex-lego/components/Popup/touch-phone/bundle';
import { Icon } from '@yandex-lego/components/Icon/touch-phone/bundle';
import { Button } from '@yandex-lego/components/Button/desktop/bundle';
// base
import { ToolsSuggest as ToolsSuggestTouchPhone, cnToolsSuggest } from '../ToolsSuggest@touch-phone';
// _size
import { withSizeM } from '../_size/ToolsSuggest_size_m';
import { withSizeS } from '../_size/ToolsSuggest_size_s';
// _theme
import { withThemeNormal } from '../_theme/ToolsSuggest_theme_normal';
// _view
import { withViewDefault } from '../_view/ToolsSuggest_view_default';
var registry = new Registry({ id: cnToolsSuggest() })
    .set('Textinput', Textinput)
    .set('Popup', Popup)
    .set('Icon', Icon)
    .set('Button', Button);
export * from '../ToolsSuggest@touch-phone';
export var ToolsSuggest = compose(composeU(withSizeM, withSizeS), withThemeNormal, withViewDefault, withRegistry(registry))(ToolsSuggestTouchPhone);
