import { FC, ReactNode, RefObject } from 'react';
import { IClassNameProps } from '@bem-react/core';
import './ToolsSuggest.css';
export * from './ToolsSuggest.classname';
declare type TextinputCommonProps = Omit<import('@yandex-lego/components/Textinput').ITextinputProps, 'hint' | 'icon' | 'iconLeft' | 'iconRight'>;
/**
 * Все доступные свойства Textinput.
 */
declare type TextinputProps = import('@yandex-lego/components/Textinput/desktop/bundle').ITextinputProps;
/**
 * Свойства наследуемые у Textinput.
 */
declare type TextinputInheritedProps = Pick<TextinputProps, 'size' | 'theme' | 'view' | 'pin' | 'state' | 'hasClear'>;
/**
 * Даннные пункта саджеста.
 */
export declare type Item = {
    /** Значение пункт */
    id: string | number;
    /** Тип значения. Для смешанных списков значений. */
    type?: string;
    [key: string]: any;
};
export interface ToolsSuggestProps extends TextinputCommonProps, TextinputInheritedProps, IClassNameProps {
    /** Список значений в попапе */
    choices?: Item[];
    /** Список выбранных значений */
    chosen?: Item[];
    /** Признак процесса загрузки */
    loading?: boolean;
    /** Максимальное кол-во выбранных элементов */
    maxChosen?: number;
    /** Признак открытого попапа */
    opened?: boolean;
    /** Признак отключенного поля. */
    disabled?: boolean;
    /** Выделенные поля в попапе */
    picked?: Item[];
    /** Содержимое в текстовом поле */
    value?: string;
    /** Отключение стрелки */
    noArrow?: boolean;
    /** Не сокращать ширину выбранных значений, для вывода поля ввода справа */
    fullWidthChosen?: boolean;
    /** Показывать выбранный элемент при фокусе в поле, даже когда он один */
    showChosenOnFocus?: boolean;
    /** Место, куда поместить выбранные значения */
    chosenPlace?: 'inline' | 'under' | 'underExceptSingle';
    /** Включить быстрое восстановление удалённых пунктов? */
    restorableChosen?: boolean;
    /** Показывать попап саджеста при удалении всех выбранных пунктов */
    showPopupOnEmptyChosen?: boolean;
    /** Показывать попап саджеста при фокусе в поле ввода */
    showPopupOnInputFocus?: boolean;
    /** Ставить фокус на инпут при клике на элемент */
    focusInputOnWrapperClick?: boolean;
    /** Добавляет кнопку, которая будет выставлять переданное значение */
    buttonValue?: Item;
    /** Содержимое кнопки для выставления значения */
    buttonValueChildren?: ReactNode;
    /** Оформление кнопки для выставления значения */
    buttonValueTheme?: string;
    /** Вид кнопки для выставления значения */
    buttonValueView?: string;
    /** Границы кнопки для выставления значения */
    buttonValuePin?: string;
    /** Обработчик прокрутки в попапе */
    onChoicesScroll?: (progress: number) => void;
    /** Обработчик изменения списка выбранных значений */
    onChosenChange?: (choices: Item[]) => void;
    /** Обработчик открытия попапа */
    onOpenedChange?: (opened: boolean) => void;
    /** Обработчик изменения списка выбранных значений в попапе */
    onPickedChange?: (choices: Item[]) => void;
    /** Обработчик изменения текста */
    onValueChange?: (value: string) => void;
    /** Кастомное отображение поля в попапе */
    renderChoice?: (choice: Item) => ReactNode;
    /** Кастомное отображение поля в списке выбранных значений */
    renderChosen?: (choice: Item) => ReactNode;
    /** Создаёт идентификатор исключающей группы (только один элемент с одинаковым идентификатором допускается) */
    createExcludingGroup?: (choice: Item) => unknown;
    /** Содержимое в попапе до пунктов */
    footer?: ReactNode;
    /** Содержимое в попапе после пунктов */
    header?: ReactNode;
    /** Сообщение о пустом значении */
    empty?: ReactNode;
    /** Ref текстового поля */
    controlRef?: RefObject<HTMLInputElement>;
    /** Ref всплывающего окна, для синхронизации ширины */
    popupRef?: RefObject<HTMLDivElement>;
    /** Ref блока в котором рисовать попап */
    scopeRef?: RefObject<HTMLElement>;
}
/**
 * Компонент саджеста.
 * @param {ToolsSuggestProps} params
 */
export declare const ToolsSuggest: FC<ToolsSuggestProps>;
