import { __assign, __read, __rest } from "tslib";
import React, { useCallback, useRef, useState, useLayoutEffect, useMemo } from 'react';
import { useComponentRegistry } from '@bem-react/di';
import { cnToolsSuggest } from './ToolsSuggest.classname';
import { ToolsSuggestChoice } from './Choice/ToolsSuggest-Choice';
import { ToolsSuggestChosen } from './Chosen/ToolsSuggest-Chosen';
import { ToolsSuggestArrow } from './Arrow/ToolsSuggest-Arrow';
import { setChoicesSubset, findIndexFromTail } from './ToolsSuggest.utils';
import { canUseDOM } from '../../lib/canUseDOM';
import { useToolsSuggest } from './ToolsSuggest.hooks/useToolsSuggest';
import './ToolsSuggest.css';
export * from './ToolsSuggest.classname';
var emptyArray = [];
/**
 * Компонент саджеста.
 * @param {ToolsSuggestProps} params
 */
export var ToolsSuggest = function (_a) {
    var pin = _a.pin, size = _a.size, theme = _a.theme, view = _a.view, choices = _a.choices, _b = _a.chosen, chosen = _b === void 0 ? emptyArray : _b, loading = _a.loading, _c = _a.maxChosen, maxChosen = _c === void 0 ? Infinity : _c, opened = _a.opened, disabled = _a.disabled, picked = _a.picked, value = _a.value, noArrow = _a.noArrow, fullWidthChosen = _a.fullWidthChosen, showChosenOnFocus = _a.showChosenOnFocus, _d = _a.chosenPlace, chosenPlace = _d === void 0 ? 'inline' : _d, restorableChosen = _a.restorableChosen, showPopupOnEmptyChosen = _a.showPopupOnEmptyChosen, showPopupOnInputFocus = _a.showPopupOnInputFocus, focusInputOnWrapperClick = _a.focusInputOnWrapperClick, buttonValue = _a.buttonValue, buttonValueChildren = _a.buttonValueChildren, buttonValueTheme = _a.buttonValueTheme, buttonValueView = _a.buttonValueView, buttonValuePin = _a.buttonValuePin, onChoicesScroll = _a.onChoicesScroll, onChosenChange = _a.onChosenChange, onOpenedChange = _a.onOpenedChange, onPickedChange = _a.onPickedChange, onValueChange = _a.onValueChange, renderChoice = _a.renderChoice, renderChosen = _a.renderChosen, createExcludingGroup = _a.createExcludingGroup, footer = _a.footer, header = _a.header, empty = _a.empty, controlRef = _a.controlRef, popupRef = _a.popupRef, scopeRef = _a.scopeRef, onBlur = _a.onBlur, onChange = _a.onChange, onKeyDown = _a.onKeyDown, onFocus = _a.onFocus, className = _a.className, rest = __rest(_a, ["pin", "size", "theme", "view", "choices", "chosen", "loading", "maxChosen", "opened", "disabled", "picked", "value", "noArrow", "fullWidthChosen", "showChosenOnFocus", "chosenPlace", "restorableChosen", "showPopupOnEmptyChosen", "showPopupOnInputFocus", "focusInputOnWrapperClick", "buttonValue", "buttonValueChildren", "buttonValueTheme", "buttonValueView", "buttonValuePin", "onChoicesScroll", "onChosenChange", "onOpenedChange", "onPickedChange", "onValueChange", "renderChoice", "renderChosen", "createExcludingGroup", "footer", "header", "empty", "controlRef", "popupRef", "scopeRef", "onBlur", "onChange", "onKeyDown", "onFocus", "className"]);
    /** Ref текстового поля. Используется, если не передан внешний. */
    var controlRefInner = useRef(null);
    /** Ref всплывающего окна. Используется, если не передан внешний. */
    var popupRefInner = useRef(null);
    /** Ref для позиционирования модального окна. */
    var anchorRef = useRef(null);
    /** Ref списка пунктов саджеста в попапе. */
    var listRef = useRef(null);
    var _e = __read(useState(false), 2), focused = _e[0], setFocused = _e[1];
    var _f = __read(useState(undefined), 2), popupStyle = _f[0], setPopupStyle = _f[1];
    var isSingle = maxChosen === 1;
    /** Устанавливает размер попапа по размеру саджеста */
    var setPopupWidth = useCallback(function () {
        var anchorElem = anchorRef.current;
        if (anchorElem) {
            var width = anchorElem.offsetWidth + "px";
            if (!popupStyle || popupStyle.width !== width) {
                setPopupStyle({ width: width });
            }
        }
    }, [popupStyle, setPopupStyle, anchorRef]);
    useLayoutEffect(function () {
        if (opened && canUseDOM()) {
            setPopupWidth();
            window.addEventListener('resize', setPopupWidth);
            window.addEventListener('scroll', setPopupWidth);
        }
        return function () {
            if (!canUseDOM()) {
                return;
            }
            window.removeEventListener('resize', setPopupWidth);
            window.removeEventListener('scroll', setPopupWidth);
        };
    }, [opened, setPopupWidth]);
    var placeInline = chosenPlace === 'inline' ||
        (chosenPlace === 'underExceptSingle' && isSingle);
    var enableRestorableChosen = restorableChosen && !isSingle;
    var _g = useToolsSuggest({
        choices: choices,
        chosen: chosen,
        loading: loading,
        maxChosen: maxChosen,
        focused: focused,
        opened: opened,
        picked: picked,
        value: value,
        restorableChosen: enableRestorableChosen,
        placeInline: placeInline,
        showPopupOnEmptyChosen: showPopupOnEmptyChosen,
        showPopupOnInputFocus: showPopupOnInputFocus,
        focusInputOnWrapperClick: focusInputOnWrapperClick,
        buttonValue: buttonValue,
        onInputFocus: setFocused,
        onChoicesScroll: onChoicesScroll,
        onChosenChange: onChosenChange,
        onOpenedChange: onOpenedChange,
        onPickedChange: onPickedChange,
        onValueChange: onValueChange,
        createExcludingGroup: createExcludingGroup,
        controlRef: controlRef || controlRefInner,
        popupRef: popupRef || popupRefInner,
        listRef: listRef,
        onBlur: onBlur,
        onChange: onChange,
        onKeyDown: onKeyDown,
        onFocus: onFocus,
    }), handleArrowClick = _g.handleArrowClick, handleChoiceMouseDown = _g.handleChoiceMouseDown, handleChoicesScroll = _g.handleChoicesScroll, handleChosenRemove = _g.handleChosenRemove, handleChosenRestore = _g.handleChosenRestore, handleInputBlur = _g.handleInputBlur, handleInputChange = _g.handleInputChange, handleInputFocus = _g.handleInputFocus, handleInputKeyDown = _g.handleInputKeyDown, handleInputMouseDown = _g.handleInputMouseDown, handleInputWrapperMouseDown = _g.handleInputWrapperMouseDown, handleSetValueClick = _g.handleSetValueClick, handlePopupClose = _g.handlePopupClose, getChosenWithRemoved = _g.getChosenWithRemoved, isIndexInRemovedChosenItems = _g.isIndexInRemovedChosenItems;
    var renderChoices = React.useCallback(function (choices) {
        if (!Array.isArray(choices)) {
            return React.createElement("div", { className: cnToolsSuggest('Empty') });
        }
        if (choices.length === 0 && !loading) {
            return React.createElement("div", { className: cnToolsSuggest('Empty') }, empty);
        }
        return setChoicesSubset(choices, choices, Infinity).map(function (choice) { return (React.createElement(ToolsSuggestChoice, { key: choice.id, picked: findIndexFromTail(picked, choice) !== -1, checked: findIndexFromTail(chosen, choice) !== -1, onMouseDown: handleChoiceMouseDown, choice: choice }, renderChoice)); });
    }, [chosen, picked, empty, handleChoiceMouseDown, renderChoice, loading]);
    var arrow = useMemo(function () { return React.createElement(ToolsSuggestArrow, { onClick: handleArrowClick }); }, [handleArrowClick]);
    var _h = useComponentRegistry(cnToolsSuggest()), Textinput = _h.Textinput, Popup = _h.Popup, Button = _h.Button;
    var realChosenItems = setChoicesSubset(chosen, chosen, maxChosen);
    var isMaxChosenCount = !isSingle && realChosenItems.length === maxChosen;
    var chosenItems = enableRestorableChosen ? getChosenWithRemoved() : realChosenItems;
    var chosenItemElements = chosenItems.map(function (choice, index) { return (React.createElement(ToolsSuggestChosen, { as: placeInline ? undefined : 'li', key: choice.id, index: index, choice: choice, restoreDisabled: isMaxChosenCount, removed: isIndexInRemovedChosenItems(index), onRemove: handleChosenRemove, onRestore: handleChosenRestore }, renderChosen)); });
    var suggestBox = (React.createElement("div", { className: cnToolsSuggest('Box'), ref: buttonValue ? undefined : anchorRef, onMouseDown: handleInputWrapperMouseDown },
        placeInline && chosenItemElements,
        React.createElement(Textinput, __assign({}, rest, { pin: pin, size: size, theme: theme, view: view, baseline: true, autoComplete: "off", disabled: disabled || isMaxChosenCount, value: value, controlRef: controlRef || controlRefInner, iconRight: noArrow ? undefined : arrow, onFocus: handleInputFocus, onBlur: handleInputBlur, onChange: handleInputChange, onMouseDown: handleInputMouseDown, onKeyDown: handleInputKeyDown }))));
    return (React.createElement("div", { className: cnToolsSuggest({
            opened: opened,
            focused: focused,
            loading: loading,
            disabled: disabled,
            single: isSingle,
            fullWidthChosen: fullWidthChosen,
            showChosenOnFocus: showChosenOnFocus,
            chosenPlace: chosenPlace,
            hasText: Boolean(value),
            maxChosenCount: isMaxChosenCount,
        }, [className]) },
        buttonValue ?
            (React.createElement("div", { className: cnToolsSuggest('Wrapper'), ref: anchorRef },
                suggestBox,
                React.createElement(Button, { className: cnToolsSuggest('SetValue'), size: size, pin: buttonValuePin, theme: buttonValueTheme, view: buttonValueView, disabled: disabled || isMaxChosenCount, onClick: handleSetValueClick }, buttonValueChildren))) :
            suggestBox,
        !placeInline && (React.createElement("ul", { className: cnToolsSuggest('ChosenList') }, chosenItemElements)),
        React.createElement(Popup, { className: cnToolsSuggest('Popup', {
                size: size,
                theme: theme,
                view: view,
            }), theme: theme, view: view, target: "anchor", direction: ['bottom-start', 'top-start'], visible: opened && !disabled, innerRef: popupRef || popupRefInner, anchor: anchorRef, scope: scopeRef, mainOffset: 4, style: popupStyle, onClose: handlePopupClose },
            React.createElement("div", { className: cnToolsSuggest('Progress', { loading: loading }) }),
            header,
            React.createElement("div", { className: cnToolsSuggest('Choices'), ref: listRef, onScroll: handleChoicesScroll }, renderChoices(choices)),
            footer)));
};
