# ToolsSuggest

<a
  href='https://github.yandex-team.ru/search-interfaces/frontend/tree/master/packages/tools-components/src/components/ToolsSuggest'
  target='_blank'>
  <img
    src='https://badger.yandex-team.ru/custom/[Исходники]/[Github][green]/badge.svg'
  />
</a>

<!-- description:start -->
Компонент саджеста.
<!-- description:end -->

## Свойства
```ts
type Item = {
    /** Значение пункта */
    id: string | number;
    /** Тип значения. Для смешанных списков значений. */
    type?: string;
    
    [key: string]: any; 
}
```

<!-- props:start -->
| Свойство                  | Тип                                                                                                                                                                                                                                                               | Описание                                                                                                                                                                                           |
| ------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| choices?                  | `Item[]`                                                                                                                                                                                                                                                          | Список значений в попапе                                                                                                                                                                           |
| chosen?                   | `Item[]`                                                                                                                                                                                                                                                          | Список выбранных значений                                                                                                                                                                          |
| loading?                  | `false \| true`                                                                                                                                                                                                                                                   | Признак процесса загрузки                                                                                                                                                                          |
| maxChosen?                | `number`                                                                                                                                                                                                                                                          | Максимальное кол-во выбранных элементов                                                                                                                                                            |
| opened?                   | `false \| true`                                                                                                                                                                                                                                                   | Признак открытого попапа                                                                                                                                                                           |
| disabled?                 | `false \| true`                                                                                                                                                                                                                                                   | Признак отключенного поля.                                                                                                                                                                         |
| picked?                   | `Item[]`                                                                                                                                                                                                                                                          | Выделенные поля в попапе                                                                                                                                                                           |
| value?                    | `string`                                                                                                                                                                                                                                                          | Содержимое в текстовом поле                                                                                                                                                                        |
| noArrow?                  | `false \| true`                                                                                                                                                                                                                                                   | Отключение стрелки                                                                                                                                                                                 |
| fullWidthChosen?          | `false \| true`                                                                                                                                                                                                                                                   | Не сокращать ширину выбранных значений, для вывода поля ввода справа                                                                                                                               |
| showChosenOnFocus?        | `false \| true`                                                                                                                                                                                                                                                   | Показывать выбранный элемент при фокусе в поле, даже когда он один                                                                                                                                 |
| chosenPlace?              | `"inline" \| "under" \| "underExceptSingle"`                                                                                                                                                                                                                      | Место, куда поместить выбранные значения                                                                                                                                                           |
| restorableChosen?         | `false \| true`                                                                                                                                                                                                                                                   | Включить быстрое восстановление удалённых пунктов?                                                                                                                                                 |
| showPopupOnEmptyChosen?   | `false \| true`                                                                                                                                                                                                                                                   | Показывать попап саджеста при удалении всех выбранных пунктов                                                                                                                                      |
| showPopupOnInputFocus?    | `false \| true`                                                                                                                                                                                                                                                   | Показывать попап саджеста при фокусе в поле ввода                                                                                                                                                  |
| focusInputOnWrapperClick? | `false \| true`                                                                                                                                                                                                                                                   | Ставить фокус на инпут при клике на элемент                                                                                                                                                        |
| buttonValue?              | `{ [key: string]: any; id: ReactText; type?: string; }`                                                                                                                                                                                                           | Добавляет кнопку, которая будет выставлять переданное значение                                                                                                                                     |
| buttonValueChildren?      | `string \| number \| false \| true \| {} \| ReactElement<any, string \| ((props: any) => ReactElement<any, string \| ... \| (new (props: any) => Component<any, any, any>)>) \| (new (props: any) => Component<any, any, any>)> \| ReactNodeArray \| ReactPortal` | Содержимое кнопки для выставления значения                                                                                                                                                         |
| buttonValueTheme?         | `string`                                                                                                                                                                                                                                                          | Оформление кнопки для выставления значения                                                                                                                                                         |
| buttonValueView?          | `string`                                                                                                                                                                                                                                                          | Вид кнопки для выставления значения                                                                                                                                                                |
| buttonValuePin?           | `string`                                                                                                                                                                                                                                                          | Границы кнопки для выставления значения                                                                                                                                                            |
| onChoicesScroll?          | `(progress: number) => void`                                                                                                                                                                                                                                      | Обработчик прокрутки в попапе                                                                                                                                                                      |
| onChosenChange?           | `(choices: Item[]) => void`                                                                                                                                                                                                                                       | Обработчик изменения списка выбранных значений                                                                                                                                                     |
| onOpenedChange?           | `(opened: boolean) => void`                                                                                                                                                                                                                                       | Обработчик открытия попапа                                                                                                                                                                         |
| onPickedChange?           | `(choices: Item[]) => void`                                                                                                                                                                                                                                       | Обработчик изменения списка выбранных значений в попапе                                                                                                                                            |
| onValueChange?            | `(value: string) => void`                                                                                                                                                                                                                                         | Обработчик изменения текста                                                                                                                                                                        |
| renderChoice?             | `(choice: Item) => ReactNode`                                                                                                                                                                                                                                     | Кастомное отображение поля в попапе                                                                                                                                                                |
| renderChosen?             | `(choice: Item) => ReactNode`                                                                                                                                                                                                                                     | Кастомное отображение поля в списке выбранных значений                                                                                                                                             |
| createExcludingGroup?     | `(choice: Item) => unknown`                                                                                                                                                                                                                                       | Создаёт идентификатор исключающей группы (только один элемент с одинаковым идентификатором допускается)                                                                                            |
| footer?                   | `string \| number \| false \| true \| {} \| ReactElement<any, string \| ((props: any) => ReactElement<any, string \| ... \| (new (props: any) => Component<any, any, any>)>) \| (new (props: any) => Component<any, any, any>)> \| ReactNodeArray \| ReactPortal` | Содержимое в попапе до пунктов                                                                                                                                                                     |
| header?                   | `string \| number \| false \| true \| {} \| ReactElement<any, string \| ((props: any) => ReactElement<any, string \| ... \| (new (props: any) => Component<any, any, any>)>) \| (new (props: any) => Component<any, any, any>)> \| ReactNodeArray \| ReactPortal` | Содержимое в попапе после пунктов                                                                                                                                                                  |
| empty?                    | `string \| number \| false \| true \| {} \| ReactElement<any, string \| ((props: any) => ReactElement<any, string \| ... \| (new (props: any) => Component<any, any, any>)>) \| (new (props: any) => Component<any, any, any>)> \| ReactNodeArray \| ReactPortal` | Сообщение о пустом значении                                                                                                                                                                        |
| controlRef?               | `RefObject<HTMLInputElement>`                                                                                                                                                                                                                                     | Ref текстового поля                                                                                                                                                                                |
| popupRef?                 | `RefObject<HTMLDivElement>`                                                                                                                                                                                                                                       | Ref всплывающего окна, для синхронизации ширины                                                                                                                                                    |
| scopeRef?                 | `RefObject<HTMLElement>`                                                                                                                                                                                                                                          | Ref блока в котором рисовать попап                                                                                                                                                                 |
| onClick?                  | `(event: MouseEvent<HTMLElement, MouseEvent>) => void`                                                                                                                                                                                                            | Событие, которое вызывается при нажатии на компонент                                                                                                                                               |
| onMouseDown?              | `(event: MouseEvent<HTMLElement, MouseEvent>) => void`                                                                                                                                                                                                            | Событие по своему действию похоже на `onClick` и возникает в момент нажатия кнопки мыши. `onClick` в каком-то смысле является комбинацией событий `onMouseDown` и `onMouseUp`                      |
| onMouseUp?                | `(event: MouseEvent<HTMLElement, MouseEvent>) => void`                                                                                                                                                                                                            | Событие по своему действию противоположно событию `onMouseDown` и происходит при отпускании кнопки мыши. Курсор должен находится в пределах HTML-элемента, к которому добавлен атрибут `onmouseup` |
| focused?                  | `false \| true`                                                                                                                                                                                                                                                   | Состояние фокуса на компоненте                                                                                                                                                                     |
| pressed?                  | `false \| true`                                                                                                                                                                                                                                                   | Состояние нажатия на компоненте                                                                                                                                                                    |
| addonAfter?               | `string \| number \| false \| true \| {} \| ReactElement<any, string \| ((props: any) => ReactElement<any, string \| ... \| (new (props: any) => Component<any, any, any>)>) \| (new (props: any) => Component<any, any, any>)> \| ReactNodeArray \| ReactPortal` | Дополнительный контент после контрола                                                                                                                                                              |
| addonBefore?              | `string \| number \| false \| true \| {} \| ReactElement<any, string \| ((props: any) => ReactElement<any, string \| ... \| (new (props: any) => Component<any, any, any>)>) \| (new (props: any) => Component<any, any, any>)> \| ReactNodeArray \| ReactPortal` | Дополнительный контент перед контролом                                                                                                                                                             |
| innerRef?                 | `(instance: HTMLSpanElement) => void \| RefObject<HTMLSpanElement>`                                                                                                                                                                                               | Ссылка на корневой DOM элемент компонента                                                                                                                                                          |
| style?                    | `CSSProperties`                                                                                                                                                                                                                                                   | Пользовательские стили на корневом DOM элементе.                                                                                                                                                   |
| state?                    | `"error"`                                                                                                                                                                                                                                                         | Визуальное состояние компонента. Может использоваться при проверке формы на корректность.                                                                                                          |
| title?                    | `string`                                                                                                                                                                                                                                                          | Всплывающая подсказка                                                                                                                                                                              |
| renderControl?            | `(props: ITextinputControlProps, component: any) => ReactElement<any, string \| ((props: any) => ReactElement<any, string \| ... \| (new (props: any) => Component<any, any, any>)>) \| (new (props: any) => Component<...>)>`                                    | Переопределяет компонент `Control`                                                                                                                                                                 |
| inputMode?                | `"search" \| "text" \| "url" \| "decimal" \| "numeric" \| "email" \| "tel"`                                                                                                                                                                                       | HTML-атрибут `inputmode`                                                                                                                                                                           |
| autoFocus?                | `false \| true`                                                                                                                                                                                                                                                   | HTML-атрибут `autofocus`                                                                                                                                                                           |
| autoComplete?             | `string`                                                                                                                                                                                                                                                          | HTML-атрибут `autocomplete`                                                                                                                                                                        |
| name?                     | `string`                                                                                                                                                                                                                                                          | Имя компонента                                                                                                                                                                                     |
| placeholder?              | `string`                                                                                                                                                                                                                                                          | Плейсхолдер                                                                                                                                                                                        |
| defaultValue?             | `string \| number`                                                                                                                                                                                                                                                | Значение по умолчанию контрола                                                                                                                                                                     |
| type?                     | `string`                                                                                                                                                                                                                                                          | HTML-атрибут `type`                                                                                                                                                                                |
| id?                       | `string`                                                                                                                                                                                                                                                          | Уникальный id компонента                                                                                                                                                                           |
| className?                | `string`                                                                                                                                                                                                                                                          | Дополнительный класс                                                                                                                                                                               |
| onChange?                 | `(event: ChangeEvent<HTMLInputElement>) => void`                                                                                                                                                                                                                  | Обработчик изменения значения                                                                                                                                                                      |
| onInput?                  | `(event: ChangeEvent<HTMLInputElement>) => void`                                                                                                                                                                                                                  | Обработчик изменения значения                                                                                                                                                                      |
| onMouseLeave?             | `(event: MouseEvent<HTMLInputElement, MouseEvent>) => void`                                                                                                                                                                                                       | Обработчик события `onMouseLeave`                                                                                                                                                                  |
| onMouseEnter?             | `(event: MouseEvent<HTMLInputElement, MouseEvent>) => void`                                                                                                                                                                                                       | Обработчик события `onMouseEnter`                                                                                                                                                                  |
| onBlur?                   | `(event: FocusEvent<HTMLInputElement>) => void`                                                                                                                                                                                                                   | Обработчик, вызываемый при срабатывании события blur                                                                                                                                               |
| onFocus?                  | `(event: FocusEvent<HTMLInputElement>) => void`                                                                                                                                                                                                                   | Обработчик, вызываемый при срабатывании события focus                                                                                                                                              |
| required?                 | `false \| true`                                                                                                                                                                                                                                                   | Устанавливает в компоненте обязательное состояние                                                                                                                                                  |
| min?                      | `string \| number`                                                                                                                                                                                                                                                | Минимальное значение при использовании `type=number` или `type=datetime-local`                                                                                                                     |
| max?                      | `string \| number`                                                                                                                                                                                                                                                | Максимальное значение при использовании `type=number` или `type=datetime-local`                                                                                                                    |
| pattern?                  | `string`                                                                                                                                                                                                                                                          | Шаблон, используемый для проверки значения при отправке формы                                                                                                                                      |
| tabIndex?                 | `number`                                                                                                                                                                                                                                                          | Целое число, определяющее должен ли переключатель участвовать в последовательной навигации по всей странице с помощью клавиатуры                                                                   |
| maxLength?                | `number`                                                                                                                                                                                                                                                          | Максимальное количество символов которое можно ввести в текстовое поле                                                                                                                             |
| readOnly?                 | `false \| true`                                                                                                                                                                                                                                                   | Запрещает изменять значение в текстовом поле                                                                                                                                                       |
| onKeyUp?                  | `(event: KeyboardEvent<HTMLInputElement>) => void`                                                                                                                                                                                                                | Обработчик, вызываемый при срабатывании события keyup                                                                                                                                              |
| onKeyPress?               | `(event: KeyboardEvent<HTMLInputElement>) => void`                                                                                                                                                                                                                | Обработчик, вызываемый при срабатывании события keypress                                                                                                                                           |
| onKeyDown?                | `(event: KeyboardEvent<HTMLInputElement>) => void`                                                                                                                                                                                                                | Обработчик, вызываемый при срабатывании события keydown                                                                                                                                            |
| size?                     | `"s" \| "m"`                                                                                                                                                                                                                                                      | Описание отсутствует.                                                                                                                                                                              |
| theme?                    | `"normal" \| "websearch"`                                                                                                                                                                                                                                         | Описание отсутствует.                                                                                                                                                                              |
| pin?                      | `"brick-brick" \| "brick-clear" \| "brick-round" \| "clear-brick" \| "clear-clear" \| "clear-round" \| "round-brick" \| "round-clear" \| "round-round"`                                                                                                           | Описание отсутствует.                                                                                                                                                                              |
| view?                     | `"default" \| "material"`                                                                                                                                                                                                                                         | Описание отсутствует.                                                                                                                                                                              |
| hasClear?                 | `false \| true`                                                                                                                                                                                                                                                   | Наличие крестика для очистки текстового поля.                                                                                                                                                      |
<!-- props:end -->

## Параметры

### createExcludingGroup

Принимает функцию, которая создаёт идентификатор исключающей группы. При этом только один элемент с одинаковым идентификатором допускается среди выбранных (выбор с предыдущего пункта будет автоматически снят).

Функция принимает объект выбранного элемента и должна вернуть значение, которое будет использовано в качестве ключа-идентификатора (может быть любым, используется в `Map`). Если элемент не принадлежит ни к какой группе, можно вернуть `null` или `undefined`.

Например, есть пункты:
```js
{ id: 'group1-item1' },
{ id: 'group1-item2' },
{ id: 'group1-item3' },
{ id: 'group2-item1' },
{ id: 'group2-item2' },
```

Если передать функцию такого вида:
```ts
const createExcludingGroup = (item: Item) => {
    const matches = /^group(\d+)-/.exec(String(item.id));

    if (!matches) {
        return;
    }

    return matches[1];
};
```

Можно будет выбрать только один элемент `group1-*` и только один `group2-*`.
