import { ComponentType, MouseEventHandler } from 'react';
import { ITextinputProps, ITextinputHasClearProps, ITextinputBaselineProps } from '@yandex-lego/components/Textinput';
import { IPopupProps, IPopupTargetAnchorProps } from '@yandex-lego/components/Popup';
import { IIconProps, IWithGlyphTypeArrowProps } from '@yandex-lego/components/Icon';
import { IButtonProps, IButtonBaselineProps } from '@yandex-lego/components/Button/desktop';
declare type TextinputEnhancedProps = ITextinputProps & ITextinputHasClearProps & ITextinputBaselineProps & {
    pin?: string;
    size?: string;
    theme?: string;
    view?: string;
    tone?: string;
};
declare type PopupEnhancedProps = IPopupProps & IPopupTargetAnchorProps & {
    theme?: string;
    view?: string;
    tone?: string;
};
declare type IconEnhancedProps = IIconProps & IWithGlyphTypeArrowProps & {
    onClick?: MouseEventHandler<HTMLElement>;
    onMouseDown?: MouseEventHandler<HTMLElement>;
};
declare type ButtonEnhancedProps = IButtonProps & IButtonBaselineProps & {
    pin?: string;
    size?: string;
    theme?: string;
    view?: string;
};
export interface ToolsSuggestRegistry {
    Textinput: ComponentType<TextinputEnhancedProps>;
    Popup: ComponentType<PopupEnhancedProps>;
    Icon: ComponentType<IconEnhancedProps>;
    Button: ComponentType<ButtonEnhancedProps>;
}
export declare const registryId: string;
export {};
