import React from 'react';
import { User } from '../../types/User';
import './UserAvatar.css';
export declare const cnUserAvatar: import("@bem-react/classname").ClassNameFormatter;
export interface UserAvatarProps {
    /** Дополнительный класс */
    className?: string;
    /** Объект с данными пользователя*/
    value: User;
    /**
     * Размер аватарки
     * @default 32
     * */
    size?: number;
    /**
     * Вывести текстом без ссылки
     * @default false
     * */
    withoutLink?: boolean;
    /**
     * Не показывать информацию об отсутствии
     * @default false
     * */
    withoutGap?: boolean;
    /** Показывать стафф-карточку по ховеру */
    withStaffCard?: boolean;
    /** В какой вкладке открывать ссылку на Стафф */
    target?: string;
    /** Подсказка */
    title?: string;
}
/**
 * Компонент аватарки пользователя с гэпом.
 * @param {UserAvatarProps} props
 */
export declare const UserAvatar: React.FC<UserAvatarProps>;
