import React, { useMemo, useRef } from 'react';
import { cn } from '@bem-react/classname';
import { useComponentRegistry } from '@bem-react/di';
import { useStaffCard } from '@yandex-int/react-hooks';
import './UserAvatar.css';
export var cnUserAvatar = cn('UserAvatar');
/**
 * Компонент аватарки пользователя с гэпом.
 * @param {UserAvatarProps} props
 */
export var UserAvatar = function (props) {
    var className = props.className, value = props.value, _a = props.size, size = _a === void 0 ? 32 : _a, _b = props.withoutLink, withoutLink = _b === void 0 ? false : _b, _c = props.withoutGap, withoutGap = _c === void 0 ? false : _c, withStaffCard = props.withStaffCard, target = props.target, title = props.title;
    var Link = useComponentRegistry(cnUserAvatar()).Link;
    var content = [(React.createElement("img", { key: "image", className: cnUserAvatar('Image'), src: value.icon, alt: value.display, width: size, height: size, 
            // @ts-ignore
            loading: "lazy" }))];
    var mods = {
        dismissed: value.dismissed || false,
    };
    // по умолчанию поле не присылают, подразумевая значение true
    var hasLicense = 'hasLicense' in value ? value.hasLicense : true;
    var anchorRef = useRef(null);
    useStaffCard({
        anchorRef: anchorRef,
        login: value.login,
    }, withStaffCard);
    if (!withoutGap &&
        value.gap &&
        value.gap.working !== true &&
        !value.dismissed &&
        hasLicense) {
        if (size < 30) {
            mods.gap = value.gap.type.replace(/_/g, '-');
        }
        else {
            content.push(React.createElement("span", { key: "gap", className: cnUserAvatar('Gap', { type: value.gap.type.replace(/_/g, '-') }), title: value.gap.message }, value.gap.message));
        }
    }
    var style = useMemo(function () { return ({
        '--user-avatar-size': size,
    }); }, [size]);
    if (withoutLink) {
        return (React.createElement("span", { className: cnUserAvatar(mods, [className]), style: style, ref: withStaffCard ? anchorRef : undefined, title: title }, content));
    }
    return (React.createElement(Link, { theme: "black", className: cnUserAvatar(mods, [className]), style: style, href: value.url, controlRef: withStaffCard ? anchorRef : undefined, target: value.url ? target || '_blank' : undefined, title: title }, content));
};
