import React from 'react';
import { useComponentRegistry } from '@bem-react/di';
import { cnUserName } from './UserName.classname';
import './UserName.css';
export * from './UserName.classname';
/**
 * Выводит имя пользователя
 * @param {UserNameProps} props
 */
export var UserName = function (_a) {
    var className = _a.className, value = _a.value, preferLogin = _a.preferLogin, withoutLink = _a.withoutLink;
    var Link = useComponentRegistry(cnUserName()).Link;
    var content = preferLogin ? value.login : value.display;
    var mods = {
        dismissed: value.dismissed,
    };
    if (withoutLink) {
        return (React.createElement("span", { className: cnUserName(mods, [className]) }, content));
    }
    return (React.createElement(Link, { theme: "black", className: cnUserName(mods, [className]), href: value.url }, content));
};
