import { __assign, __awaiter, __generator, __read, __values } from "tslib";
import * as React from 'react';
import urlJoin from 'url-join';
import { cnWikiFormatter } from './WikiFormatter.classname';
function loadClient(settings) {
    return __awaiter(this, void 0, void 0, function () {
        var wfaasUrl, res, json;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    wfaasUrl = settings.wfaasUrl;
                    return [4 /*yield*/, fetch(urlJoin(wfaasUrl, '/cors/.get_bundle'), {
                            credentials: 'include',
                            mode: 'cors',
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                            },
                        })];
                case 1:
                    res = _a.sent();
                    return [4 /*yield*/, res.json()];
                case 2:
                    json = _a.sent();
                    return [2 /*return*/, json.result];
            }
        });
    });
}
function loadStyle(href) {
    return new Promise(function (resolve, reject) {
        var bundleStyle = document.createElement('link');
        bundleStyle.setAttribute('rel', 'stylesheet');
        bundleStyle.setAttribute('href', href);
        bundleStyle.addEventListener('load', function () {
            resolve();
        });
        bundleStyle.addEventListener('error', reject);
        document.head.appendChild(bundleStyle);
    });
}
function loadScript(src) {
    return new Promise(function (resolve, reject) {
        var bundleScript = document.createElement('script');
        bundleScript.setAttribute('src', src);
        bundleScript.addEventListener('load', function () {
            resolve();
        });
        bundleScript.addEventListener('error', reject);
        document.head.appendChild(bundleScript);
    });
}
function appendClient(client, nonce) {
    return __awaiter(this, void 0, void 0, function () {
        var stylesheetRemoteChunks, javascriptInlineChunks, javascriptRemoteChunks, stylesheetPromise, javascriptPromise;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    stylesheetRemoteChunks = client.stylesheetRemoteChunks, javascriptInlineChunks = client.javascriptInlineChunks, javascriptRemoteChunks = client.javascriptRemoteChunks;
                    stylesheetPromise = stylesheetRemoteChunks.reduce(function (promise, stylesheetRemoteChunk) {
                        return promise.then(function () { return loadStyle(stylesheetRemoteChunk); });
                    }, Promise.resolve());
                    javascriptPromise = new Promise(function (resolve, reject) {
                        var promises = [];
                        // @ts-ignore
                        if (typeof window.jQuery === 'undefined') {
                            // https://st.yandex-team.ru/WIKI-14131
                            promises.push(loadScript('https://yastatic.net/jquery/2.2.3/jquery.min.js'));
                        }
                        Promise.all(promises).then(function () {
                            var e_1, _a;
                            try {
                                for (var javascriptInlineChunks_1 = __values(javascriptInlineChunks), javascriptInlineChunks_1_1 = javascriptInlineChunks_1.next(); !javascriptInlineChunks_1_1.done; javascriptInlineChunks_1_1 = javascriptInlineChunks_1.next()) {
                                    var javascriptInlineChunk = javascriptInlineChunks_1_1.value;
                                    var script = document.createElement('script');
                                    script.setAttribute('nonce', nonce);
                                    script.innerHTML = javascriptInlineChunk;
                                    document.head.appendChild(script);
                                }
                            }
                            catch (e_1_1) { e_1 = { error: e_1_1 }; }
                            finally {
                                try {
                                    if (javascriptInlineChunks_1_1 && !javascriptInlineChunks_1_1.done && (_a = javascriptInlineChunks_1.return)) _a.call(javascriptInlineChunks_1);
                                }
                                finally { if (e_1) throw e_1.error; }
                            }
                            javascriptRemoteChunks.reduce(function (promise, javascriptRemoteChunk) {
                                return promise.then(function () { return loadScript(javascriptRemoteChunk); });
                            }, Promise.resolve())
                                .then(resolve, reject);
                        }, reject);
                    });
                    return [4 /*yield*/, Promise.all([
                            stylesheetPromise,
                            javascriptPromise,
                        ])];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
var initClientPromise = null;
function initClient(settings, nonce) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (window.Ya && Ya.FormatterViewPort) {
                        return [2 /*return*/];
                    }
                    if (!(initClientPromise instanceof Promise)) return [3 /*break*/, 2];
                    return [4 /*yield*/, initClientPromise];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
                case 2:
                    initClientPromise = loadClient(settings)
                        .then(function (client) { return appendClient(client, nonce); });
                    return [4 /*yield*/, initClientPromise];
                case 3:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
var defaults = {
    instance: 'intranet',
    platform: 'desktop',
    lang: 'ru',
    code_theme: 'github',
    wfaasUrl: 'https://wfaas.yandex-team.ru',
    magiclinks_url: 'https://magiclinks.yandex-team.ru/magiclinks/v1/links',
    tracker_url: 'https://st.yandex-team.ru',
    staff_url: 'https://staff.yandex-team.ru',
    schi_url: 'https://schi.yandex-team.ru',
    at_url: 'https://clubs.at.yandex-team.ru',
    forms_url: 'https://forms.yandex-team.ru',
    wiki_url: 'https://wiki.yandex-team.ru',
    wiki_api_url: 'https://wiki-api.yandex-team.ru',
    docviewer_url: 'https://docviewer.yandex-team.ru',
    charts_url: 'https://charts-beta.yandex-team.ru',
    statface_url: 'https://stat-beta.yandex-team.ru',
    yastatic_url: 'https://yastatic.net',
    remark: { woofmd: { actions: [] } },
};
export var WikiFormatterHtml = function (props) {
    var nonce = props.nonce, html = props.html, className = props.className, _a = props.onFormatterInstance, onFormatterInstance = _a === void 0 ? function () { } : _a;
    var domElemRef = React.useRef(null);
    var settings = React.useMemo(function () { return (__assign(__assign({}, defaults), props.settings)); }, [props.settings]);
    React.useEffect(function () {
        initClient(settings, nonce).then(function () {
            var domElem = domElemRef.current;
            if (domElem === null) {
                return;
            }
            onFormatterInstance(new Ya.FormatterViewPort({ domElem: domElem, settings: settings }));
        });
    }, [settings, nonce, onFormatterInstance]);
    React.useLayoutEffect(function () {
        var domElem = domElemRef.current;
        if (domElem === null || typeof Ya === 'undefined' || !Ya.FormatterViewPort) {
            return;
        }
        Ya.FormatterViewPort.init(domElem);
        // html – зависимость не лишняя,
        // нужно инициализировать DOM каждый раз,
        // когда меняется children
    }, [html]);
    return (React.createElement("div", { className: cnWikiFormatter({}, [className]), ref: domElemRef, dangerouslySetInnerHTML: {
            __html: html,
        } }));
};
export var WikiFormatter = function (props) {
    var _a = __read(React.useState(''), 2), html = _a[0], setHtml = _a[1];
    var _b = __read(React.useState(null), 2), formatter = _b[0], setFormatter = _b[1];
    var nonce = props.nonce, className = props.className, _c = props.children, children = _c === void 0 ? '' : _c, _d = props.onContentUpdated, onContentUpdated = _d === void 0 ? function () { } : _d, settings = props.settings;
    React.useEffect(function () {
        if (!formatter) {
            return;
        }
        formatter.renderToString(children).then(setHtml);
    }, [formatter, children, setHtml]);
    React.useLayoutEffect(function () {
        if (html) {
            onContentUpdated();
        }
    }, [html, onContentUpdated]);
    return (React.createElement(WikiFormatterHtml, { nonce: nonce, html: html, className: className, settings: settings, onFormatterInstance: setFormatter }));
};
