import { useCallback } from 'react';
import { formatDate, parseDate } from '../components/Datepicker/Datepicker';
/**
 * Хук для парсинга дат Datepicker и перевода их в строки.
 * Также содержит в себе обработчик для onDateChange.
 */
export function useDatepickerStringDates(_a) {
    var value = _a.value, min = _a.min, max = _a.max, onChange = _a.onChange;
    var handleDateChange = useCallback(function (date) {
        if (onChange) {
            onChange({ target: { value: formatDate(date) || '' } });
        }
    }, [onChange]);
    return {
        value: parseDate(value),
        min: parseDate(min),
        max: parseDate(max),
        handleDateChange: handleDateChange,
    };
}
