# @yandex-int/si.ci.requests

> Обёртка над [got](https://github.com/sindresorhus/got) с ретраями и логированием.

## Ключевые особенности

* :pencil: [Логирование запросов, ответов и всех ретраев, а также причин их отсутствия](#Логирование)
* :chart_with_upwards_trend: [Сквозная связь запроса и его ретраев](#request-id)
* :repeat: [Проработанное поведение ретраев](#Описание-работы-ретраев)

## Установка

```shell
npm install @yandex-int/si.ci.requests
```

## Зачем, ведь есть `got`, `asker` и прочие решения?

Этот клиент построен как расширение HTTP-клиента `got`, поэтому все его методы полностью совместимы с оригинальными,
включая дополнительные методы, описанные ниже.

Мы используем `got` – превосходный и многофункциональный HTTP-клиент. Однако, нам нужны «умные» ретраи, `uuid` для
каждого запроса и логирование всех действий пакета: запрос, ответ, ретрай.

Возможно, в будущем этот пакет можно будет значительно упростить:

* [sindresorhus/got#559](https://github.com/sindresorhus/got/issues/559)
* [sindresorhus/got#625](https://github.com/sindresorhus/got/issues/625)
* [sindresorhus/got#561](https://github.com/sindresorhus/got/pull/561)

## Использование

```js
const requests = require('@yandex-int/si.ci.requests');

(async () => {
    const response = await requests('https://github.com', {
        json: true,
        headers: {
            Authorization: `OAuth xxx`
        }
    });
})();
```

## :warning: Важная информация и советы

### Первый аргумент

В ближайших релизах `got` планируют убрать возможность передавать первым аргументом что-либо, не относящееся к описанию
URL запроса, например, передачу заголовков.

Поэтому *настоятельно рекомендуется* использовать первый аргумент (`url`) только как строку, содержащую URL запроса,
а для указания и переопределения параметров запроса, а также его настроек – второй аргумент (`options`).

## Дополнительные опции

### `nonRetriableStatusCodes`

* Type: `number[]`
* Default: `[]`

 Список кодов ответа, которые не нужно ретраить.

### `maxRetryTotalTime`

* Type: `number`
* Default: `undefined`

Максимальное время в миллисекундах, по истечении которого ретраи будут отключены.

### `applyMaxRetryTotalTimeBeforeRetry`

* Type: `boolean`
* Default: `true`

Если `true`, то ограничение `maxRetryTotalTime` будет применяться до того, как выполнится запланированный ретрай. В противном случае ограничение будет применено после выполнения ретрая.

Рассмотрим пример, в котором ретрай будет отменён. Значение `maxRetryTotalTime` равно 60 секундам.

```console
11:00:00 Первый запрос
11:00:01 Получен неудовлетворительный ответ
11:00:01 Запланирован ретрай на 11:00:10
11:00:10 Повторный запрос
11:00:10 Получен неудовлетворительный ответ
11:00:10 Запланирован ретрай на 11:05:00
11:00:10 Ретрай отменён
```

В примере выше последний ретрай был отменён из-за того, что он запланирован через пять минут, а время, которое пройдёт
до того, как ретрай будет выполнен уже больше 60 секунд.

В противном случае (когда значение `applyMaxRetryTotalTimeBeforeRetry` установлено в `false`) ретрай сначала будет
выполнен, а следующий отменён. Так происходит, потому что на момент планирования ретрая суммарное время, отведённое
на этот запрос (со всеми ретраями), ещё не превысило ограничение.

### `truncateResponseBodyLogAfter`

* Type: `number`
* Default: `100`

Максимальное количество логируемых символов тела неуспешного ответа. В случае, если число символов ответа превышает
указанное значение, то в конец добавляется маркер `<truncated>`.

> :book: Для отключения логирования тела неуспешного ответа, необходимо установить значение `0`. Для полного вывода тела ответа
необходимо указать значение `Infinity`.

### `ignoreRetryAfterHeader`

* Type: `boolean`
* Default: `false`

Если `true`, то заголовок `retry-after` в ответе будет проигнорирован.

## Дополнительные методы

### `.withRetriablePostMethod`

В нашей практике встречаются случаи, когда нам необходимо ретраить POST-запросы. Например, когда мы отправляем статус
для коммита на GitHub.

### `.withRetriable404StatusCode`

На практике встречаются случаи, когда нам необходимо ретраить 404 статусы ответов. Например, когда мы делаем запросы для TestPalm.

> :warning: Обратите внимание, что ретраить все POST-запросы не безопасно, так как это может вызывать различные
> сайд-эффекты, которых, скорее всего, вы не ожидаете. Например, создание двух и более Sandbox-тасок, когда сервер
> не успевет ответить на первый запрос, при этом всё-таки создаёт таску.

## Дополнительные константы

Пакет экспортирует набор констант, который можно использовать для «тонкой» настройки ретраев. Все костанты доступны из неймспейса `.constants.CONSTANT_NAME`.

* `HTTP_STATUS_CODES` — все известные пакету коды статусов ответов.
* `RETRIABLE_STATUS_CODES` — коды статусов ответов, которые ретраятся пакетом по умолчанию.
* `NON_RETRIABLE_STATUS_CODES` — коды статусов ответов, которые не ретраятся пакетом по умолчанию.
* `RETRIABLE_METHODS` — методы, которые ретраятся пакетом по умолчанию.

## Дополнительное поведение

### Логирование

> :book: Логирование можно включить, используя переменную окружения `DEBUG=si:ci:requests`.

Логируется сам запрос, ответ на него, запланированные ретраи и их отмена, включая результаты каждого ретрая.

### Request ID

Все записи в логе, которые относятся к одному и тому же запросу (сам запрос и все его ретраи), имеют одинаковый UUID, представленный в заголовке `x-request-id`.

### User Agent

По умолчанию этот пакет использует в качестве UA следующую строку: `@yandex-int/si.ci.requests@(версия этого пакета)`.

## Описание работы ретраев

### Ограничения для ретраев

* Количество допустимых ретраев, описанное в опции `retryCount`;
* Максимальная задержка между ретраями, описанная в опции `retry.maxRetryAfter`;
* Максимальное время на запрос (со всеми ретраями), описанное в опции `maxRetryTotalTime`.
* Сетевые ошибки, описанные в [`RETRIABLE_NETWORK_ERRORS`](./lib/constants.js);
* Методы, описанные в опции `retry.methods`. Значения по умолчанию: [`RETRIABLE_METHODS`](./lib/constants.js);
* Коды ответов, описанные в опции `retry.statusCodes`. Значения по умолчанию: [`RETRIABLE_STATUS_CODES`](./lib/constants.js).

### Задержка между ретраями

* Значение, указанное в заголовке `retry-after`, если не включена опция `ignoreRetryAfterHeader`;
* Значение, полученное по алгоритму [`экспоненциальной выдержки`](https://en.wikipedia.org/wiki/Exponential_backoff).

### Возможные причины прекращения ретраев

* Превышено количество допустимых ретраев;
* Запрос завершился сетевой ошибкой, которую нельзя ретраить;
* Запрос имеет метод, который нельзя ретраить;
* Запрос имеет код ответа, который нельзя ретраить;
* Задержка между ретраями больше допустимой.
* Время, отведённое на запрос со всеми ретраями истекло.

## FAQ

### Я хочу уточнить или заменить стандартный `user-agent`

Так как этот пакет полностью поддерживаем стандартное поведение `got`, то можно просто передать нужный заголовок:

```js
const response = await requests('https://ya.ru', {
    headers: {
        'user-agent': 'my-awesome-library'
    }
});
```

### Я хочу использовать своё значение для идентификации запроса в логах

В таком случае необходимо указать необходимое значение в качестве значения для заголовка `x-request-id` при запросе:

```js
const response = await requests('https://ya.ru', {
    headers: {
        'x-request-id': 'my-request-uuid'
    }
});
```

### Я не хочу считать количество необходимых ретраев – хочу ограничить ретраи по времени

Для этого хорошо подходит опция [`maxRetryTotalTime`](#maxRetryTotalTime).

```js
const req = requests('https://ya.ru/404', {
    retryCount: Infinity, // Разрешаем ретраить бесконечное количество раз
    retry: {
      maxRetryAfter: Infinity // Разрешаем бесконечную задержку между ретраями
    },
    maxRetryTotalTime: 30 * 60 * 1000 // 30 минут
});
```

> :warning: При установке значения `Infinity` для опции `retryCount` в логах будет отображаться,
> что `maxRetryCount` равно `null`. Это вызвано тем, что мы используем `JSON.stringify`.

### Я хочу использовать `Promise.all` – можно?

Можно. Однако, нужно учесть, что при падении одного из запросов – остальные будут ретраиться даже после выхода
из инструкции `Promise.all`.

```js
const a = requests('https://ya.ru/404', { retryCount: 1 }); // 404
const b = requests('https://ya.ru', { retryCount: 10 }); // 504

try {
    const all = await Promise.all([a, b]);
} catch (error) {
    /**
     * Будет вызван сразу после падения запроса «A».
     * При этом запрос «B» будет продолжаться со всеми доступными для него ретраями.
     */
    console.log('error');
}
```

Так как `got` реализует [Dispose-паттерн](https://en.wikipedia.org/wiki/Dispose_pattern) для ручной отмены действия,
можно обойти указанное поведение, используя метод `.cancel`:

```js
const a = requests('https://ya.ru/404', { retryCount: 1 }); // 404
const b = requests('https://ya.ru', { retryCount: 10 }); // 504

const reqs = [a, b];

try {
    const all = await Promise.all(reqs);
} catch (error) {
    reqs.forEach((req) => req.cancel()); // Отмена запроса
}
```
