import got = require('got');

type GotFnExtension = {
    (url: requests.GotUrl): requests.GotPromise<string>;
    (url: requests.GotUrl, options: requests.GotJSONOptions): requests.GotPromise<any>;
    (url: requests.GotUrl, options: requests.GotFormOptions<string>): requests.GotPromise<string>;
    (url: requests.GotUrl, options: requests.GotFormOptions<null>): requests.GotPromise<Buffer>;
    (url: requests.GotUrl, options: requests.GotBodyOptions<string>): requests.GotPromise<string>;
    (url: requests.GotUrl, options: requests.GotBodyOptions<null>): requests.GotPromise<Buffer>;
};

type GotExtension = {
    constants: {
        HTTP_STATUS_CODES: number[];
        RETRIABLE_STATUS_CODES: number[];
        NON_RETRIABLE_STATUS_CODES: number[];
        RETRIABLE_METHODS: Set<string>;
    };

    nonRetriableStatusCodes: number[];
    withRetriablePostMethod: got.GotInstance<GotFnExtension>;
    withRetriable404StatusCode: got.GotInstance<GotFnExtension>;
};

type GotOptionsExtension = {
    nonRetriableStatusCodes?: number[];
    maxRetryTotalTime?: number;
    retryCount?: number;
    applyMaxRetryTotalTimeBeforeRetry?: boolean;
    truncateResponseBodyLogAfter?: number;
    ignoreRetryAfterHeader?: boolean;
};

declare const requests: got.GotInstance<GotFnExtension> & GotExtension;

declare namespace requests {
    type GotFn = got.GotFn;
    type GotJSONFn = got.GotJSONFn;
    type GotFormFn<T extends string | null> = got.GotFormFn<T>;
    type GotBodyFn<T extends string | null> = got.GotBodyFn<T>;
    type GotInstance<T = GotFn> = got.GotInstance<T>;
    type GotExtend = got.GotExtend;
    type GotStreamFn = got.GotStreamFn;
    type GotUrl = got.GotUrl;
    type Hooks<Options, Body extends Buffer | string | object> = got.Hooks<Options, Body>;
    type BeforeRequestHook<Options> = got.BeforeRequestHook<Options>;
    type BeforeRedirectHook<Options> = got.BeforeRedirectHook<Options>;
    type BeforeRetryHook<Options> = got.BeforeRetryHook<Options>;
    type AfterResponseHook<Options, Body extends Buffer | string | object> = got.AfterResponseHook<Options, Body>;
    type GotBodyOptions<E extends string | null> = got.GotBodyOptions<E> & GotOptionsExtension;
    type GotJSONOptions = got.GotJSONOptions & GotOptionsExtension;
    type GotFormOptions<E extends string | null> = got.GotFormOptions<E> & GotOptionsExtension;
    type GotOptions<E extends string | null> = got.GotOptions<E>;
    type TimeoutOptions = got.TimeoutOptions;
    type RetryFunction = got.RetryFunction;
    type RetryOptions = got.RetryOptions;
    type AgentOptions = got.AgentOptions;
    type Cache = got.Cache;
    type Response<B extends Buffer | string | object> = got.Response<B>;
    type GotPromise<B extends Buffer | string | object> = got.GotPromise<B>;
    type GotEmitter = got.GotEmitter;
    type GotError = got.GotError;
    type Progress = got.Progress;
}

export = requests;
