/**
 * @param {Object} res
 * @returns {boolean}
 */
function isResponseWithNetworkProblem(res) {
    return res.name === 'RequestError';
}

/**
 * @param {Object} res
 * @returns {boolean}
 */
function isTimedoutResponse(res) {
    return res.name === 'TimeoutError';
}

/**
 * @param {number} retryNumber
 * @returns {number}
 */
function getBackoff(retryNumber) {
    return Math.round(((1 << retryNumber) * 1000) + (Math.random() * 100));
}

module.exports = {
    isResponseWithNetworkProblem,
    isTimedoutResponse,
    getBackoff
};
