import { assert } from 'chai';
import { AdapterBaobabFeature } from './fixtures/BaobabFeature';
import { AdapterReactFeature } from './fixtures/ReactFeature';
import { ISnippetContext } from '../../lib/Context';
import { AdaptersRegistry, AdaptersExpRegistry, IAdapterRuntimeData } from '../../lib/taburet';
import { ISerpSnippet, ISerpDocument, Construct, IPrivExternals } from '../../typings';
import { AdaptersRuntime } from './index';

const PLATFORM = 'desktop';

const registry = new AdaptersRegistry(PLATFORM);
const expRegistry = new AdaptersExpRegistry(PLATFORM);

registry.add(AdapterBaobabFeature);
registry.add(AdapterReactFeature);

const privExternals = ({ Counter: () => null, pushAssets: () => null } as unknown) as IPrivExternals;
const context = { expFlags: {}, device: {} } as ISnippetContext;
let document: ISerpDocument;

describe('SerpAdapterRuntime', () => {
    let runtime: AdaptersRuntime;
    let snippet: ISerpSnippet;

    beforeEach(() => {
        runtime = new AdaptersRuntime({
            adapters: {
                base: registry.provide(),
                experiments: expRegistry.provide(),
            },
            assets: {
                'static/features/BaobabFeature/BaobabFeature@desktop': {},
                'static/features/ReactFeature/ReactFeature@desktop': {},
                'static/react-polyfill': {},
            },
            platform: PLATFORM,
        });
    });

    it('should render React to html wrap', () => {
        snippet = { type: 'react-feature' };

        const { data } = runtime.select({
            context,
            snippet,
            document,
            privExternals,
        }) as IAdapterRuntimeData<Construct.IReactCompatible>;

        assert.deepEqual(data, {
            block: 'html',
            preventLegacy: true,
            godMode: true,
            content: {
                tag: '',
                logSubtree: [],
                content: 'React',
            },
        });
    });

    it('should return baobab tree as logSubtree', () => {
        snippet = { type: 'baobab-feature' };

        const { data } = runtime.select({
            context,
            snippet,
            document,
            privExternals,
        }) as IAdapterRuntimeData<Construct.IReactCompatible>;

        assert.deepEqual((data.content as Construct.IBaobabLogEscapeHatch).logSubtree, [
            { id: '123', name: 'testName' },
        ]);
    });
});
