/* globals specs */
specs(
    {
        feature: 'Музыкальный плеер',
        type: 'Исполнитель',
    },
    () => {
        beforeEach(function() {
            const PO = this.PO;

            return this.browser.yaOpenSerp({ text: 'linkin park песни' }, PO.musicplayer());
        });

        it('Проверка тайтла и альбома', function() {
            const PO = this.PO;

            return (
                this.browser
                    // тайтл плеера
                    .yaCheckLinkOpener(PO.musicplayer.title())
                    .then(url => {
                        assert.include(
                            url.href,
                            '//music.yandex.ru/artist/36800?from=serp',
                            'Ссылка с заголовка Музыкального плеера не ведет на Я.Музыку',
                        );
                    })
                    .yaCheckCounter2(PO.musicplayer.title(), {
                        path: '/snippet/musicplayer/artist/title',
                        vars: '-adapters=musicplayer,-source=wizard',
                    })
                    // ссылка на иконке исполнителя
                    .yaCheckLinkOpener(PO.musicplayer.photoLink())
                    .then(url => {
                        assert.include(
                            url.href,
                            '//music.yandex.ru/artist/36800?from=serp',
                            'Ссылка на иконке альбома Музыкального плеера не ведет на Я.Музыку',
                        );
                    })
                    .yaCheckCounter2(PO.musicplayer.photoLink(), {
                        path: '/snippet/musicplayer/artist/image',
                        vars: '-adapters=musicplayer,-source=wizard',
                    })
            );
        });

        it('Проверка треков', function() {
            const PO = this.PO;

            return (
                this.browser
                    // кнопка 'плей'
                    .yaCheckLinkOpener(
                        PO.musicplayer.track.play(),
                        'Ссылка с кнопки плей Музыкального плеера не имеет таргет YaMusicFromSerp',
                        { target: 'YaMusicFromSerp' },
                    )
                    .then(url => {
                        return this.browser.yaCheckURL(
                            url,
                            'https://music.yandex.ru/artist/36800?from=serp_autoplay&playTrack=178529',
                            'Ссылка с кнопки плей Музыкального плеера не ведет на Я.Музыку',
                            { skipProtocol: true },
                        );
                    })
                    .yaCheckCounter2(PO.musicplayer.track.play(), {
                        path: '/snippet/musicplayer/artist/play',
                        vars: '-adapters=musicplayer,-source=wizard',
                    })

                    // трек
                    .yaCheckLinkOpener(
                        PO.musicplayer.trackLink(),
                        'Ссылка в названии трека не имеет таргет YaMusicFromSerp',
                        { target: 'YaMusicFromSerp' },
                    )
                    .then(url => {
                        return this.browser.yaCheckURL(
                            url,
                            'https://music.yandex.ru/artist/36800?from=serp_autoplay&playTrack=178529',
                            'Ссылка в названии трека не ведет на Я.Музыку',
                            { skipProtocol: true },
                        );
                    })
                    .yaCheckCounter2(PO.musicplayer.trackLink(), {
                        path: '/snippet/musicplayer/artist/track',
                        vars: '-adapters=musicplayer,-source=wizard',
                    })
            );
        });

        it('Проверка футера', function() {
            const PO = this.PO;

            return (
                this.browser
                    // ссылка 'еще N треков'
                    .yaCheckLinkOpener(PO.musicplayer.moreLink())
                    .then(url => {
                        assert.include(
                            url.href,
                            '//music.yandex.ru/artist/36800?from=serp',
                            'Ссылка "еще N треков" Музыкального плеера не ведет на Я.Музыку',
                        );
                    })
                    .yaCheckCounter2(PO.musicplayer.moreLink(), {
                        path: '/snippet/musicplayer/artist/more',
                        vars: '-adapters=musicplayer,-source=wizard',
                    }) // ссылка на иконке радио
                    .yaCheckLinkOpener(PO.musicplayer.radio())
                    .then(url => {
                        assert.include(
                            url.href,
                            '//music.yandex.ru/artist/36800?radio=play&from=serp',
                            'Ссылка на иконке радио Музыкального плеера не ведет на Я.Музыку',
                        );
                    })
                    .yaCheckCounter2(PO.musicplayer.radio(), {
                        path: '/snippet/musicplayer/artist/radio',
                        vars: '-adapters=musicplayer,-source=wizard',
                    })

                    // ссылка Похожие исполнители
                    .yaCheckLinkOpener(PO.musicplayer.radioSimilar())
                    .then(url => {
                        assert.include(
                            url.href,
                            '//music.yandex.ru/artist/92178?from=serp',
                            'Ссылка с похожими исполнителями не ведет на Я.Музыку',
                        );
                    })
                    .yaCheckCounter2(PO.musicplayer.radioSimilar(), {
                        path: '/snippet/musicplayer/artist/similar',
                        vars: '-adapters=musicplayer,-source=wizard',
                    })
            );
        });
    },
);
