import React from 'react';

import { cnGallery } from '..';
import { ScrollerItem } from '../../Scroller/Item/Scroller-Item';
import { GalleryThumb } from '../Gallery.typings';

interface IGalleryRowProps {
    registerRowWidth: (width: number) => void;
    children: GalleryThumb[];
    isScrollable?: boolean;
    isLast?: boolean;
    thumbGap: number;
}

/**
 * Строка галереи
 */
export class GalleryRow extends React.PureComponent<IGalleryRowProps> {
    protected thumbsRefs: Array<React.RefObject<HTMLDivElement>> = [];

    componentDidMount() {
        const width = this.thumbsRefs.reduce((sum, ref) => {
            if (ref.current) {
                return sum + ref.current.offsetWidth;
            }

            return sum;
        }, 0);
        const gapsWidth = this.thumbsRefs.length ? (this.thumbsRefs.length - 1) * this.props.thumbGap : 0;

        this.props.registerRowWidth(width + gapsWidth);
    }

    render() {
        return (
            <div className={cnGallery('Row', { last: this.props.isLast ? 'yes' : 'no' })}>
                {this.props.children.map((withThumb, i) => {
                    const ref = React.createRef<HTMLDivElement>();

                    this.thumbsRefs[i] = ref;

                    if (this.props.isScrollable) {
                        return (
                            <ScrollerItem key={i}>
                                {({ className }) => withThumb(cnGallery('Thumb', { type: 'rows' }, [className]), ref)}
                            </ScrollerItem>
                        );
                    }

                    return withThumb(cnGallery('Thumb', { type: 'rows' }), ref, i);
                })}
            </div>
        );
    }
}
