# uglified

> Checks if the code is **minified**.

## Install

```sh
$ npm install @zippytech/uglified --save
```

## Usage

```js
var minified = require('@zippytech/uglified')

console.log(minified) // `true` or `false`
```

## Features

 * targeted at browser environments, when you want to know at runtime if the code is minified or not
 * full test-coverage
 * simple implementation

## Module name inspiration

The module does not have any relation to [`uglify-js`](https://www.npmjs.com/package/uglify-js), but the module name `minified` was taken on `npm`, so we thought a good alternative name would be `uglified`. Probably not the best choice, but does the job anyway.

## Implementation details

It uses a function with only an arg (which is never used in the function body), and the function body only containing a comment. It then tests if the `toString` of the function returns the same value as the original function code. If it does not, the code is probably minified, so returns **true**.

## LICENSE

#### [Apache2](./LICENSE)
