/// <reference types="node" />
import requests from "@yandex-int/si.ci.requests";
import { URL } from "url";
declare type PartialOptions = Partial<requests.GotOptions<string>> | undefined;
export declare type Secret = {
    key: string;
    value: string;
};
export declare type ErrorResponse = {
    status: "error";
    message: string;
    code: string;
};
export declare type VersionResponse = {
    status: "ok";
    version: {
        comment: string;
        created_at: number;
        created_by: number;
        creator_login: string;
        secret_name: string;
        secret_uuid: string;
        value: Array<Secret>;
        version: string;
    };
};
/**
 * В текущей версии поддерживается авторизация только по OAuth-токену.
 * @see https://vault-api.passport.yandex.net/docs/
 * @see https://a.yandex-team.ru/arc/trunk/arcadia/library/python/vault_client
 */
export declare class VaultClient {
    protected oAuthToken: string;
    protected urlParams?: Partial<URL> | undefined;
    protected requestOptions?: PartialOptions;
    constructor(oAuthToken: string, urlParams?: Partial<URL> | undefined, requestOptions?: PartialOptions);
    /**
     * Возвращает значение секрета
     * @param id - идентификатор версии либо идентификатор секрета. Если указан идентификатор секрета, будет возвращен
     * секрет последней версии.
     */
    getVersion(id: string): Promise<Array<Secret>>;
    protected request(pathname: string): Promise<Array<Secret>>;
}
export {};
//# sourceMappingURL=index.d.ts.map