"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const si_ci_requests_1 = __importDefault(require("@yandex-int/si.ci.requests"));
const url_1 = require("url");
function resultIsError(response) {
    return response.status === "error";
}
const defaultVaultHost = "https://vault-api.passport.yandex.net/";
/**
 * В текущей версии поддерживается авторизация только по OAuth-токену.
 * @see https://vault-api.passport.yandex.net/docs/
 * @see https://a.yandex-team.ru/arc/trunk/arcadia/library/python/vault_client
 */
class VaultClient {
    constructor(oAuthToken, urlParams, requestOptions) {
        this.oAuthToken = oAuthToken;
        this.urlParams = urlParams;
        this.requestOptions = requestOptions;
    }
    /**
     * Возвращает значение секрета
     * @param id - идентификатор версии либо идентификатор секрета. Если указан идентификатор секрета, будет возвращен
     * секрет последней версии.
     */
    async getVersion(id) {
        return this.request(`/1/versions/${id}`);
    }
    async request(pathname) {
        const url = new url_1.URL(defaultVaultHost);
        const options = Object.assign({}, this.requestOptions, { headers: Object.assign({}, (this.requestOptions || {}).headers, { Authorization: `OAuth ${this.oAuthToken}` }) });
        Object.assign(url, this.urlParams, { pathname });
        const res = await si_ci_requests_1.default(url, options);
        // TODO: добавить валидацию возвращаемого ответа вместо простого as
        const response = JSON.parse(res.body);
        if (resultIsError(response)) {
            throw new Error(`${response.code}: ${response.message}`);
        }
        return response.version.value;
    }
}
exports.VaultClient = VaultClient;
//# sourceMappingURL=index.js.map