export declare type Location = {
    line: number;
    column: number;
};
export interface Key {
    name: string;
    nameRaw: string;
    keyset: string;
    context?: string;
    params?: Array<Object>;
    location: Location;
    range: [number, number];
    fragment: string;
}
export declare type KeyStorage = Array<Key>;
export declare function extractI18NKeysFromFiles(fileNames: string[], i18nModuleName?: string, i18nKeysetExtension?: string): KeyStorage;
export declare function extractI18NKeysFromSourceCode(sourceCode: string, i18nModuleName?: string, i18nKeysetExtension?: string, sourceFileName?: string): KeyStorage;
