import React, { ReactNode, FC, ComponentType } from 'react';
export declare type RegistryContext = Record<string, Registry>;
export declare const registryContext: React.Context<Record<string, Registry>>;
export declare const RegistryConsumer: React.ExoticComponent<React.ConsumerProps<Record<string, Registry>>>;
export declare function withRegistry(...registries: Registry[]): <P>(Component: ComponentType<P>) => FC<P>;
export interface IComponentRegistryConsumerProps {
    id: string;
    children: (registry: any) => ReactNode;
}
export declare const ComponentRegistryConsumer: FC<IComponentRegistryConsumerProps>;
export declare const useRegistries: () => Record<string, Registry>;
export declare const useComponentRegistry: <T extends {}>(id: string) => T;
export interface IRegistryOptions {
    id: string;
    overridable?: boolean;
}
declare const registryHocMark = "RegistryHoc";
export declare type HOC<T> = (WrappedComponent: ComponentType) => ComponentType<T>;
declare type IRegistryEntity<T = any> = ComponentType<T> | IRegistryHOC<T>;
declare type IRegistryComponents = Record<string, IRegistryEntity>;
interface IRegistryHOC<T> extends React.FC<T> {
    $symbol: typeof registryHocMark;
    hoc: HOC<T>;
}
export declare class Registry {
    id: string;
    overridable: boolean;
    private components;
    constructor({ id, overridable }: IRegistryOptions);
    /**
     * Set react component in registry by id.
     *
     * @param id component id
     * @param component valid react component
     */
    set<T>(id: string, component: ComponentType<T>): this;
    /**
     * Set hoc for extends component in registry by id
     *
     * @param id component id
     * @param hoc hoc for extends component
     */
    extends<T>(id: string, hoc: HOC<T>): this;
    /**
     * Set react components in registry via object literal.
     *
     * @param componentsSet set of valid react components
     */
    fill(componentsSet: IRegistryComponents): this;
    /**
     * Get react component from registry by id.
     *
     * @param id component id
     */
    get<T>(id: string): IRegistryEntity<T>;
    /**
     * Returns list of components from registry.
     */
    snapshot<RT>(): RT;
    /**
     * Override components by external registry.
     * @internal
     *
     * @param otherRegistry external registry
     */
    merge(otherRegistry?: Registry): Registry;
    /**
     * Returns extended or replacing for base impleme
     *
     * @param base base implementation
     * @param overrides overridden implementation
     */
    private mergeComponents;
}
export {};
