import { ReactNode } from 'react';
import { FixedSizeList, FixedSizeListProps } from 'react-window';
import Tree, { NodeComponentProps, NodeData, NodeRecord, TreeProps, TreeState, UpdateOptions } from './Tree';
export declare type FixedSizeNodeData = NodeData;
export declare type FixedSizeNodeComponentProps<T extends FixedSizeNodeData> = NodeComponentProps<T>;
export declare type FixedSizeNodeRecord<T extends FixedSizeNodeData> = NodeRecord<T>;
export declare type FixedSizeUpdateOptions = UpdateOptions;
export declare type FixedSizeTreeProps<T extends FixedSizeNodeData> = TreeProps<FixedSizeNodeComponentProps<T>, T> & Readonly<Pick<FixedSizeListProps, 'itemSize'>>;
export declare type FixedSizeTreeState<T extends FixedSizeNodeData> = TreeState<FixedSizeNodeComponentProps<T>, FixedSizeNodeRecord<T>, FixedSizeUpdateOptions, T>;
export declare class FixedSizeTree<T extends FixedSizeNodeData = NodeData> extends Tree<FixedSizeNodeComponentProps<T>, FixedSizeNodeRecord<T>, FixedSizeUpdateOptions, T, FixedSizeTreeProps<T>, FixedSizeTreeState<T>, FixedSizeList> {
    constructor(props: FixedSizeTreeProps<T>, context: any);
    render(): ReactNode;
}
