"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

exports.__esModule = true;
exports.VariableSizeTree = void 0;

var _objectWithoutPropertiesLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutPropertiesLoose"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inheritsLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/inheritsLoose"));

var _react = _interopRequireDefault(require("react"));

var _reactWindow = require("react-window");

var _Tree2 = _interopRequireWildcard(require("./Tree"));

var _utils = require("./utils");

var computeTree = (0, _Tree2.createTreeComputer)({
  createRecord: function createRecord(data, _ref) {
    var recomputeTree = _ref.recomputeTree,
        resetAfterId = _ref.resetAfterId;
    var record = {
      data: data,
      height: data.defaultHeight,
      isOpen: data.isOpenByDefault,
      resize: function resize(height, shouldForceUpdate) {
        record.height = height;
        resetAfterId(record.data.id, shouldForceUpdate);
      },
      toggle: function toggle() {
        record.isOpen = !record.isOpen;
        return recomputeTree({
          refreshNodes: record.isOpen,
          useDefaultHeight: true
        });
      }
    };
    return record;
  },
  shouldUpdateRecords: function shouldUpdateRecords(options) {
    var _options$useDefaultHe;

    return (0, _utils.shouldUpdateRecords)(options) || ((_options$useDefaultHe = options.useDefaultHeight) != null ? _options$useDefaultHe : false);
  },
  updateRecord: function updateRecord(record, recordId, options) {
    if (options.useDefaultHeight) {
      record.height = record.data.defaultHeight;
    }

    (0, _utils.updateRecord)(record, recordId, options);
  },
  updateRecordOnNewData: function updateRecordOnNewData(record, options) {
    (0, _utils.updateRecordOnNewData)(record, options);

    if (options.useDefaultHeight) {
      record.height = record.data.defaultHeight;
    }
  }
});

var VariableSizeTree = /*#__PURE__*/function (_Tree) {
  (0, _inheritsLoose2.default)(VariableSizeTree, _Tree);

  function VariableSizeTree(props, context) {
    var _this;

    _this = _Tree.call(this, props, context) || this;
    _this.getItemSize = _this.getItemSize.bind((0, _assertThisInitialized2.default)(_this));
    _this.state = (0, _extends2.default)({}, _this.state, {
      computeTree: computeTree,
      resetAfterId: _this.resetAfterId.bind((0, _assertThisInitialized2.default)(_this))
    });
    return _this;
  }

  var _proto = VariableSizeTree.prototype;

  _proto.resetAfterId = function resetAfterId(id, shouldForceUpdate) {
    var _this$list$current;

    if (shouldForceUpdate === void 0) {
      shouldForceUpdate = false;
    }

    (_this$list$current = this.list.current) == null ? void 0 : _this$list$current.resetAfterIndex(this.state.order.indexOf(id), shouldForceUpdate);
  };

  _proto.recomputeTree = function recomputeTree(options) {
    var _this2 = this;

    return _Tree.prototype.recomputeTree.call(this, options).then(function () {
      var _this2$list$current;

      (_this2$list$current = _this2.list.current) == null ? void 0 : _this2$list$current.resetAfterIndex(0, true);
    });
  };

  _proto.render = function render() {
    var _this$props = this.props,
        children = _this$props.children,
        itemSize = _this$props.itemSize,
        rowComponent = _this$props.rowComponent,
        treeWalker = _this$props.treeWalker,
        rest = (0, _objectWithoutPropertiesLoose2.default)(_this$props, ["children", "itemSize", "rowComponent", "treeWalker"]);
    return /*#__PURE__*/_react.default.createElement(_reactWindow.VariableSizeList, Object.assign({}, rest, {
      itemCount: this.state.order.length,
      itemData: this.state // eslint-disable-next-line @typescript-eslint/unbound-method
      ,
      itemSize: itemSize != null ? itemSize : this.getItemSize,
      ref: this.list
    }), rowComponent);
  };

  _proto.getItemSize = function getItemSize(index) {
    var _this$state = this.state,
        order = _this$state.order,
        records = _this$state.records;
    return records[order[index]].height;
  };

  return VariableSizeTree;
}(_Tree2.default);

exports.VariableSizeTree = VariableSizeTree;